<? require_once($_SERVER['BASEPATH'].DIRECTORY_SEPARATOR.'common/base.php'); ?>
<? require_once($_SERVER['BASEPATH'].DIRECTORY_SEPARATOR.'common/header.php'); ?>
<?= BaseUtils::includeCoreJs('jquery.ipaddress.js'); ?>
<?= BaseUtils::includeCoreJs('jquery.numberMask.js'); ?>
<? $conf = new hvac(); ?>
<script type="text/javascript" src="js/jquery-ui.min.js"></script>
<script type="text/javascript" src="js/jsxt-string.js"></script>
<script type="text/javascript" src="js/jquery.noty.packaged.min.js"></script>
<script type="text/javascript" src="js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="js/sweet-alert.min.js"></script>
<link rel="stylesheet" media="screen" type="text/css" href="css/jquery-aristo.css" />
<link rel="stylesheet" media="screen" type="text/css" href="css/sweet-alert.css">
<? if (hvac::isDirty()) { ?><script>$( "#commit" ).css("visibility", "visible");</script><? } ?>
<style>
  .formy { width: 200px; }
</style>
<div class="page">
    <h1>Zones configuration</h1>
    <h6>Configure My Home and <?= HVAC_BRAND ?> zone pairs</h6>
    <br>
    <div style="width: 98%;">
      <table id="zones" class="standard" width="100%">
        <thead>
          <tr>
            <th class="standard" width="15%"><b>Name</b></td>
            <th class="standard" width="10%"><b>HVAC<br>Address</b></td>
            <th class="standard" width="20%"><b>My Home Probe<br>(Gateway/Address)</b></td>
            <th class="standard" width="10%"><b>HVAC Touchscreen<br>(Area/Address)</b></td>
            <th class="standard" width="10%"><b>HVAC<br>AUTO Fan Speed support</b></td>
            <th class="standard" width="10%"><b>Heating<br>mode</b></td>
            <th class="standard" width="10%"><b>Cooling<br>mode</b></td>
            <th class="standard" style="text-align: right;" width="15%"><b>Action</b></td>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td class="standard" colspan="7">Loading..</td>
          </tr>
        </tbody>
      </table>
    </div>
    <div id="dialog-edit" title="Edit zone" style="display:none;">
      <form id="dialog-edit-form" class="ui-form">
        <input type="hidden" name="action" value="zone.save" />
        <input type="hidden" name="id" id="form_id" value="" />
        <div id="tabs">
          <ul>
            <li><a href="#tabs-1">General</a></li>
            <li><a href="#tabs-2">Advanced</a></li>
            <li><a href="#tabs-3">HVAC Touchscreen</a></li>
            <li><a href="#tabs-4">Lock/Unlock</a></li>
			<!-- +FEAT. HVAC Master/Slaves -->
            <li><a href="#tabs-5">HVAC Slaves</a></li>
            <!-- -FEAT. HVAC Master/Slaves -->
          </ul>
          <div class="tabs-spacer"></div>
          <div id="tabs-1" style="height: 300px;">
            <table width="100%" style="border-spacing: 10px; border-collapse: separate;">
              <tr>
                <td width="40%"><label for="name">Name</label></td>
                <td>
                  <input class="formy" type="text" name="name" id="form_name" value="" />
                </td>
              </tr>
              <tr>
                <td><label for="hvacaddress">HVAC Address</label></td>
                <td>
                  <select class="formy" name="hvacaddress" id="form_hvacaddress">
                    <? 	foreach(createRange("",0,63) as $key=>$value) {
						if( $key < 16 ) {
							$valueString = $value . "   -  0" . strtoupper( dechex( $value ) ) . " Hex";
						} else {
							$valueString = $value . "  -  " . strtoupper( dechex( $value ) ) . " Hex";
						}
					?> 
						
						<option value="<?= $key ?>"><?= $valueString ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
              <tr>
                <td><label for="ownserver">Probe Bus</label></td>
                <td>
                  <select class="formy" name="ownserver" id="form_ownserver">
                    <option value="0">Local Bus</option>
                    <? foreach($conf->getOWNServers() as $server) { ?> 
                    <option value="<?= $server['id'] ?>"><?= $server['name'] ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
              <tr>
                <td><label for="probeaddress">Probe Address</label></td>
                <td>
                  <select class="formy" name="probeaddress" id="form_probeaddress">
                    <option  value="0">Not installed</option>
                    <? foreach(createRange("",1,99) as $key=>$value) { ?> 
                      <option value="<?= $key ?>"><?= $value ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
              <tr>
                <td><label for="probefanmode">Probe Type</label></td>
                <td>
                  <select class="formy" name="probefanmode" id="form_probefanmode">
                    <option value="yes">Fan Probe</option>
                    <option value="no">Standard Probe</option>
                  </select>
                </td>
              </tr>
            </table>
          </div>
          <div id="tabs-2" style="height: 300px;">
            <table width="100%" style="border-spacing: 10px; border-collapse: separate;">
              <tr>
                <td width="40%"><label for="locking_buttonlock">HVAC Auto Fan Mode support</label>
                <td>
                  <select class="formy" name="autofanspeed" id="form_autofanspeed">
                    <!-- <option value="yes">Native support</option>  -->
                    <option value="no">Emulated by driver</option>
                  </select>
                </td>
              </tr>    
              <tr>
                <td>
                  <label for="heating_mode"><abbr title="Standard: follow My Home setpoint&#013;Integrate: use the integration delta setpoint&#013;Don't use: turn off this unit on this season">Heating Mode</a></label>
                </td>
                <td>
                  <select class="formy" name="heating_mode" id="form_heating_mode">
                    <option value="SINGLE">Standard</option>
                    <option value="INTEGRATE">Integrated</option>
                    <option value="FANONLY">Fan only</option>
                    <option value="OFF">Don't use this system</option>
                  </select>
                </td>            
              </tr>
              <tr>
                <td>
                  <label for="heating_type"><abbr title="Use 'Driver and My Home' if My Home actuators are configured for this season">Heating Actuator</abbr></label>
                </td>
                <td>
                  <select class="formy" name="heating_type" id="form_heating_type">
                    <option value="PHY">Driver and My Home</option>
                    <option value="VIRT">This driver only</option>
                  </select>
                </td>
              </tr>
			  <!--
              <tr>
                <td>
                  <label for="heating_defaultairdir">Heating Air Direction</label>
                </td>
                <td>
                  <select class="formy" name="heating_defaultairdir" id="form_heating_defaultairdir">
                    <option value="-1">None</option>
                  </select>
                </td>
              </tr>
			  -->
              <tr>
                <td>
                  <label for="cooling_mode"><abbr title="Standard: follow My Home setpoint&#013;Integrate: use the integration delta setpoint&#013;Don't use: turn off this unit on this season">Cooling Mode</abbr></label>
                </td>
                <td>
                  <select class="formy" name="cooling_mode" id="form_cooling_mode">
                    <option value="SINGLE">Standard</option>
                    <option value="INTEGRATE">Integrated</option>
                    <option value="FAN">Fan only</option>
                    <option value="OFF">Don't use this system</option>
                  </select>
                </td>
              </tr>
              <tr>
                <td>
                  <label for="cooling_type"><abbr title="Use 'Driver and My Home' if My Home actuators are configured for this season">Cooling Actuator</abbr></label>
                </td>
                <td>
                  <select class="formy" name="cooling_type" id="form_cooling_type">
                    <option value="PHY">Driver and My Home</option>
                    <option value="VIRT">This driver only</option>
                  </select>
                </td>
              </tr>
			  <!--
              <tr>
                <td>
                  <label for="cooling_defaultairdir">Cooling Air Direction</label>
                </td>
                <td>
                  <select class="formy" name="cooling_defaultairdir" id="form_cooling_defaultairdir">
                    <option value="-1">None</option>
                  </select>
                </td>
              </tr>
			  -->
              <tr>
                <td>
                  <label for="adjust"><abbr title="Adjust the setpoint sent to the HVAC system&#013;to compensate the measured ambient temperature&#013;Ambient Reference needs to be set to My Home">Setpoint compensation</abbr></label>
                </td>
                <td>
                  <select class="formy" name="adjust" id="form_adjust">
                    <option value="NONE">None</option>
                    <option value="HEATING">On heating mode only</option>
                    <option value="COOLING">On cooling mode only</option>
                    <option value="BOTH">On heating and cooling mode</option>
                  </select>
                </td>
              </tr>               
            </table>
          </div>
          <div id="tabs-3" style="height: 300px;">
            My Home touchscreen that implements the HVAC Template can display more information about AC Unit and Fancoil. 
            Each HVAC unit is identified by an Area and Address as well as a My Home standard zone.
            <br /><br />
            <table width="100%" style="border-spacing: 10px; border-collapse: separate;">
              <tr>
                <td width="40%">
                  <label for="bacnetarea">Area</label>
                </td>
                <td>
                  <select class="formy" name="bacnetarea" id="form_bacnetarea">
                    <option value="0">Not installed</option>
                    <? foreach(createRange("",1,99) as $key=>$value) { ?> 
                      <option value="<?= $key ?>"><?= $value ?></option>
                    <? } ?>
                  </select>
                </td>  
              </tr>               
              <tr>
                <td>
                  <label for="bacnetaddress">Address</label>
                </td>
                <td>
                  <select class="formy" name="bacnetaddress" id="form_bacnetaddress">
                    <option value="0">Not installed</option>
                    <? foreach(createRange("",1,99) as $key=>$value) { ?> 
                      <option value="<?= $key ?>"><?= $value ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
            </table>
          </div>
          <div id="tabs-4" style="height: 300px;">
            Lock/Unlock commands can be used to turn off, temporary until setpoint change or till unlock commmand, the <?= HVAC_BRAND ?> HVAC unit for this zone.
            <input type="hidden" name="locking_cenaddress_b" value="" /> <input type="hidden" name="locking_cenaddress_a" value="" /> <input type="hidden" name="locking_cenaddress_pl" value="" />
            <table width="100%" style="border-spacing: 10px; border-collapse: separate;">
              <tr>
                <td width="40%"><label for="locking_cenplusaddress_ck">Enabled this function</label></td>
                <td>
                  <input type="checkbox" name="locking_cenplusaddress_ck" id="form_locking_cenplusaddress_ck" checked />
                </td>
              </tr>
              <tr id="cen_1">
                <td width="40%"><label for="locking_cenplusaddress">CEN+ Address</label></td>
                <td>
                  <input type="text" name="locking_cenplusaddress" id="form_locking_cenplusaddress" size="5" value="0" />
                </td>
              </tr>
              <tr id="cen_2">
                <td><label for="locking_buttonlock">Lock Button</label>
                <td>
                  <select name="locking_buttonlock" id="form_locking_buttonlock">
                    <option value="-1">None</option>
                    <? foreach(createRange("",1,31) as $key=>$value) { ?> 
                      <option value="<?= $key ?>"><?= $value ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
              <tr id="cen_3">
                <td><label for="locking_buttontemporary">Temporary Lock</td>
                <td>
                  <select name="locking_buttontemporary" id="form_locking_buttontemporary">
                    <option value="-1">None</option>
                    <? foreach(createRange("",1,31) as $key=>$value) { ?> 
                      <option value="<?= $key ?>"><?= $value ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
              <tr id="cen_4">
                <td width="12%"><label for="locking_buttonunlock">Unlock</td>
                <td>                  
                  <select name="locking_buttonunlock" id="form_locking_buttonunlock">
                    <option value="-1">None</option>
                    <? foreach(createRange("",1,31) as $key=>$value) { ?> 
                      <option value="<?= $key ?>"><?= $value ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
            </table>
          </div>
		            <!-- +FEAT. HVAC Master/Slaves -->
          <div id="tabs-5" style="height: 300px;">
            To control multiple hvac zones with the same MY HOME probe please select the below fields.
            <table width="100%" style="border-spacing: 10px; border-collapse: separate;">
              <tr>
                <td width="40%"><label for="name">Slave 1</label></td>
                <td>
                  <select class="formy" name="slave_1" id="form_slave_1">
					<option value="-1"></option>					
                    <? 	foreach(createRange("",0,63) as $key=>$value) {
						if( $key < 16 ) {
							$valueString = $value . "   -  0" . strtoupper( dechex( $value ) ) . " Hex";
						} else {
							$valueString = $value . "  -  " . strtoupper( dechex( $value ) ) . " Hex";
						}
					?> 
						
						<option value="<?= $key ?>"><?= $valueString ?></option>
                    <? } ?>
                  </select>
                </td>
              </tr>
              <tr>
                <td width="40%"><label for="name">Slave 2</label></td>
                <td>
                  <select class="formy" name="slave_2" id="form_slave_2">
                    <option value="-1"></option>
                    <? 	foreach(createRange("",0,63) as $key=>$value) {
						if( $key < 16 ) {
							$valueString = $value . "   -  0" . strtoupper( dechex( $value ) ) . " Hex";
						} else {
							$valueString = $value . "  -  " . strtoupper( dechex( $value ) ) . " Hex";
						}
					?> 
						
						<option value="<?= $key ?>"><?= $valueString ?></option>
                    <? } ?>
                  </select>

                </td>
              </tr>
              <tr>
                <td width="40%"><label for="name">Slave 3</label></td>
                <td>
                  <select class="formy" name="slave_3" id="form_slave_3">
                    <option value="-1"></option>
                    <? 	foreach(createRange("",0,63) as $key=>$value) {
						if( $key < 16 ) {
							$valueString = $value . "   -  0" . strtoupper( dechex( $value ) ) . " Hex";
						} else {
							$valueString = $value . "  -  " . strtoupper( dechex( $value ) ) . " Hex";
						}
					?> 
						
						<option value="<?= $key ?>"><?= $valueString ?></option>
                    <? } ?>
                  </select>

                </td>
              </tr>
              <tr>
                <td width="40%"><label for="name">Slave 4</label></td>
                <td>
                  <select class="formy" name="slave_4" id="form_slave_4">
                    <option value="-1"></option>
                    <? 	foreach(createRange("",0,63) as $key=>$value) {
						if( $key < 16 ) {
							$valueString = $value . "   -  0" . strtoupper( dechex( $value ) ) . " Hex";
						} else {
							$valueString = $value . "  -  " . strtoupper( dechex( $value ) ) . " Hex";
						}
					?> 
						
						<option value="<?= $key ?>"><?= $valueString ?></option>
                    <? } ?>
                  </select>

                </td>
              </tr>
              <tr>
                <td width="40%"><label for="name">Slave 5</label></td>
                <td>
                  <select class="formy" name="slave_5" id="form_slave_5">
                    <option value="-1"></option>
                    <? 	foreach(createRange("",0,63) as $key=>$value) {
						if( $key < 16 ) {
							$valueString = $value . "   -  0" . strtoupper( dechex( $value ) ) . " Hex";
						} else {
							$valueString = $value . "  -  " . strtoupper( dechex( $value ) ) . " Hex";
						}
					?> 
						
						<option value="<?= $key ?>"><?= $valueString ?></option>
                    <? } ?>
                  </select>

                </td>
              </tr>
            </table>
          </div>
          <!-- -FEAT. HVAC Master/Slaves -->
        </div>
      </form>
    </div>
    <script type="text/javascript">
      
		$(document).ready(function() {

			$( "#form_locking_cenaddress_b" ).spinner({min: 0, max: 9});
			$( "#form_locking_cenaddress_a" ).spinner({min: 0, max: 15});
			$( "#form_locking_cenaddress_pl" ).spinner({min: 0, max: 15});
			$( "#form_locking_cenplusaddress" ).spinner({min: 0, max: 2047});
			$( "#tabs" ).tabs();

			load();

			$('#form_locking_cenplusaddress_ck').change(function() {

				if ($('#form_locking_cenplusaddress_ck').attr('checked')) {

					$('#cen_1').show();
					$('#cen_2').show();
					$('#cen_3').show();
					$('#cen_4').show();

				} else {

					$('#cen_1').hide();
					$('#cen_2').hide();
					$('#cen_3').hide();
					$('#cen_4').hide();

				}
			});
		});
      
		$('#dialog-edit').dialog({
		  
			autoOpen: false, height: 500, width: 800, modal: true, closeOnEscape: true, dialogClass: "ui-dialog", resizable: false,
			buttons: {
			
				"Save": function() {
					
					// +FEAT. HVAC Master/Slaves
					//check if hvac slaves are different from the hvac master

					if ($('#form_hvacaddress').val() == $('#form_slave_1').val() ||
						$('#form_hvacaddress').val() == $('#form_slave_2').val() ||
						$('#form_hvacaddress').val() == $('#form_slave_3').val() ||
						$('#form_hvacaddress').val() == $('#form_slave_4').val() ||
						$('#form_hvacaddress').val() == $('#form_slave_5').val()) {
						
						var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: 'hvac slave address must be different from hvac master address'});
						return;
					}

					if ($('#form_slave_1').val() > -1) {
				  
						if ($('#form_slave_1').val() == $('#form_slave_2').val() ||
							$('#form_slave_1').val() == $('#form_slave_3').val() ||
							$('#form_slave_1').val() == $('#form_slave_4').val() ||
							$('#form_slave_1').val() == $('#form_slave_5').val()) {

							var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: 'hvac slave address must be different from each other'});
							return;
						}
					}

					if ($('#form_slave_2').val() > -1) {
				  
						if ($('#form_slave_2').val() == $('#form_slave_3').val() ||
							$('#form_slave_2').val() == $('#form_slave_4').val() ||
							$('#form_slave_2').val() == $('#form_slave_5').val()) {

							var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: 'hvac slave address must be different from each other'});
							return;
						}
					}

					if ($('#form_slave_3').val() > -1) {
				  
						if ($('#form_slave_3').val() == $('#form_slave_4').val() ||
							$('#form_slave_3').val() == $('#form_slave_5').val()) {

							var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: 'hvac slave address must be different from each other'});
							return;
						}
					}

					if ($('#form_slave_4').val() > -1) {
				  
						if ($('#form_slave_4').val() == $('#form_slave_5').val()) {

							var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: 'hvac slave address must be different from each other'});
							return;
						}
					}
					// -FEAT. HVAC Master/Slaves					
				
					if (!$('#form_locking_cenplusaddress_ck').attr('checked')) $('#form_locking_cenplusaddress').val("0");
					
					$.ajax({
						
						type: "POST",
						dataType: "json",
						url:"command.php",
						data: $('#dialog-edit-form').serialize(),
						cache: false,
						success: function(data){
							
							if (data.success) {
								
								load();
								$( "#dialog-edit" ).dialog( "close" );
								var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'success', modal: false, text: data.message});
								
							} else {
								
								var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: data.message});
							}
						},
						error: function(msg){
							var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: 'Communication error, please retry!'});
						}
					});
				},
				Cancel: function() {
					$( "#dialog-edit" ).dialog( "close" );
				}
			}
		});
      
		function load() {
			
			$.getJSON("command.php", {"action":"zone.list"}, function(data) {
          
				if (data.dirty) $( "#commit" ).css("visibility", "visible");

				$('#zones tbody > tr').remove();
				$.each(data.list, function(i,v) {
					
					var add  = '<tr class="standard">';
					add += '<td class="standard">%s</td>'.sprintf(v.name);
					add += '<td class="standard">%s</td>'.sprintf(v.hvacaddress);
                
					if (v.probeaddress == 0) {
						add += '<td class="standard">None</td>';
					} else {
						add += '<td class="standard">%s/%d %s</td>'.sprintf(v.ownservername,v.probeaddress,(v.probefanmode == 'yes' ? '(Fan Probe)':''));
					}
                
					if (v.bacnetarea == 0 || v.bacnetaddress == 0) { 
						add += '<td class="standard">- / -</td>';
					} else {
						add += '<td class="standard">%d / %d</td>'.sprintf(v.bacnetarea,v.bacnetaddress);
					}
                
					add += '<td class="standard">%s</td>'.sprintf(v.autofanspeed);
					add += '<td class="standard">%s</td>'.sprintf(v.s_heating_mode);
					add += '<td class="standard">%s</td>'.sprintf(v.s_cooling_mode);
					add += '<td class="standard" style="padding: 2px; text-align:right;"><input type="button" onClick="modify(%d);" value="edit"><input type="button" onClick="del(%d);" value="delete"></td>'.sprintf(v.id,v.id);
					add += '</tr>'
            
					$('#zones tbody').append(add);
				});
          
				$('#zones tbody').append('<tr class="standard"><td colspan="8" class="standard" style="padding: 2px; text-align:right;"><input type="button" onClick="modify(0);" value="add new"></td></tr>');
			});
		}
      
		function modify(id) {
        
			$.getJSON("command.php", {"action":"zone.load", "id": id}, function(data) {
          
				$.each(data, function(i,v) {
            
					if ( $( "#form_" + i ).length ) {
              
						$("#form_" + i).val(v);
					}
            
					if (i == "locking_cenaddress") {
					
						var vals = v.split(/\-/);

						if (vals.length == 3) {
                
							$("#form_locking_cenaddress_b").val(vals[0]);
							$("#form_locking_cenaddress_a").val(vals[1]);
							$("#form_locking_cenaddress_pl").val(vals[2]);
						}
					}
            
					if (i == "locking_cenplusaddress") {
						
						if (v == "0") {
                
							$('#form_locking_cenplusaddress_ck').attr('checked',false);
						} else {
							$('#form_locking_cenplusaddress_ck').attr('checked',true);
						}
						$('#form_locking_cenplusaddress_ck').trigger('change');
					}
				});
          
				$('#tabs').tabs({ active: 0 });
				$('#dialog-edit').dialog('open');
			});
		}
      
		function del(id) {
        
			swal({
				
				title: "Are you sure?",
				text: "This zone will be deleted. Do you want to continue?",
				type: "warning",
				showCancelButton: true,
				confirmButtonColor: "#DD6B55",
				confirmButtonText: "Yes, proceed!",
				closeOnConfirm: true,
				allowOutsideClick: true
			},
			
			function() {       
				//if (confirm("This zone will be deleted. Do you want to continue?")) {
				$.getJSON("command.php", {"action":"zone.delete", "id": id}, function(data) {
            
					if (data.success) {
						load();
						var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'success', modal: false, text: data.message});
					} else {
						var n = noty({layout: 'bottom', killer: true, timeout: 5000, type: 'warning', modal: false, text: data.message});
					}
				});
			});
		}
      
		$('#form_name').bind('keypress', function (event) {
          
			if (event.keyCode == 8 || event.keyCode == 9 || event.keyCode == 13) {
            
				return true;
			}
			
			var regex = new RegExp("^[a-zA-Z0-9 ]+$");
			var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
			
			if (!regex.test(key)) {
				event.preventDefault();
				return false;
			}
		});
	</script>      
</div>
<? require_once($_SERVER['BASEPATH'].DIRECTORY_SEPARATOR.'common/footer.php'); ?>