var TimerObject = (function () {

    // constructor
    var drv = function (_timeout, _functionDescription, _func, _oneShot, _maxTimerValue) {

        var that = this;
        var prefix = "TMR-OBJ";

        var timeout = _timeout;
        var functionDescription = _functionDescription;
        var oneShot = _oneShot;
        var maxTimerValue = _maxTimerValue;
        var timerCounter = 0;
        var active = false;

        this.onClock = function () {

            if (active === true) {

                //logger.finest("%s function %s onClock timerCounter: %d".sprintf(prefix, functionDescription, timerCounter));

                if (timerCounter == maxTimerValue) {

                    timerCounter = 0;

                } else {

                    timerCounter++;
                }

                //logger.finest("%s function %s onClock timerCounter: %d".sprintf(prefix, functionDescription, timerCounter));

                if (timerCounter == timeout) {

                    //logger.finer("%s onClock timer expired value: %d, executing function %s".sprintf(prefix, timerCounter, functionDescription));
                    timerCounter = 0;

                    if (oneShot === true) {

                        active = false;
                    }

                    _func();
                }

            } else {

                // not active
                timerCounter = 0;
            }

            return -1;
        }

        this.start = function () {

            //logger.finer("%s function %s start".sprintf(prefix, functionDescription));
            active = true;
        }

        this.stop = function () {

            //logger.finer("%s function %s stop".sprintf(prefix, functionDescription));
            active = false;
            timerCounter = 0;
        }

        this.isRunning = function () {

            //logger.finer("%s function %s isRunning: %s".sprintf(prefix, functionDescription, active ? "true" : "false"));
            return active;
        }

        this.restart = function () {

            //logger.finer("%s function %s restart".sprintf(prefix, functionDescription));
            active = true;
            timerCounter = 0;
        }
    }

    return drv;

})();


var TimerManager = (function () {

    // constructor
    var drv = function () {

        var that = this;
        var prefix = "TMR-MGR";
        var counter = 0;
        var clockTimer = new mhTimer();
        clockTimer.setInterval(1000);
        clockTimer.setAction(timeout.bind(this));
        clockTimer.start();

        var timers = [];

        this.add = function (timerObject) {

            var currentCounter = counter;
            timers[currentCounter] = timerObject;
            counter++;

            //logger.info("%s add counter: %d".sprintf(prefix, currentCounter));
            return currentCounter;
        }

        this.remove = function (index) {

            if (timers.hasOwnProperty(index)) {

                delete timers[index];
            }
        }

        this.start = function (index) {

            // +OFD
            //for (var index in timers) {

            //    if (timers.hasOwnProperty(index)) {

            //        logger.info("%s timers[%d]".sprintf(prefix, index));
            //    }
            //}
            // -OFD

            if (timers.hasOwnProperty(index)) {

                timers[index].start();
                //logger.finer("%s start timers[%d] started".sprintf(prefix, index));

                return true;

            } else {

                logger.warning("%s start unable to start timers[%d]".sprintf(prefix, index));

                return false;
            }
        }

        this.stop = function (index) {

            // +OFD
            //for (var index in timers) {

            //    if (timers.hasOwnProperty(index)) {

            //        logger.info("%s timers[%d]".sprintf(prefix, index));
            //    }
            //}
            // -OFD

            if (timers.hasOwnProperty(index)) {

                timers[index].stop();
                //logger.finer("%s stop timers[%d] stopped".sprintf(prefix, index));

                return true;

            } else {

                logger.warning("%s stop unable to stop timers[%d]".sprintf(prefix, index));

                return false;
            }
        }

        function timeout() {

            for (var i in timers) {

                timers[i].onClock();
            }
        }
    }

    return drv;

})();