<?

  define("DRIVER_BASENAME",basename(realpath(dirname(__FILE__).DIRECTORY_SEPARATOR."..")));
  define("DRIVER_CONFIG_FILE",realpath(dirname(__FILE__).DIRECTORY_SEPARATOR."..")."/conf/config.xml");
  define("DRIVER_CONFIG_TEMP",sprintf("/tmp/%s-config.xml",DRIVER_BASENAME));
  define("HVAC_NAME","LG Modbus");
  define("HVAC_BRAND","LG");
  
  /*!
   * This class manages HVAC configuration file
   */
  class hvac {
    
    var $config;
    var $lasterror = '';
    var $validmodels = array(8=>"HC-A8MB",32=>"HC-A32MB",64=>"HC-A64MB",160=>"CSNET-WEB");
    var $validmodes = array("SINGLE"=>"","INTEGRATE"=>"","FANONLY"=>"","NONE"=>"Do not use this unit");
    var $validprobes = array("VIRT"=>"Gateway Mode","PHY"=>"My Home actuator(s) installed");
    var $validreference = array("MH"=>"Use My Home's probe as reference","HVAC"=>"Use HVAC's probe as reference");
    var $validthermalprotection = array("OFF"=>"OFF","NONE"=>"Keep protection setpoint");
	var $validheatsetpointreached = array("100"=>"Turn OFF the unit","0"=>"Set AUTO fan speed","1"=>"Set LOW fan speed","99"=>"No action","98"=>"Set AUTO mode");
	var $validcoolsetpointreached = array("100"=>"Turn OFF the unit","0"=>"Set AUTO fan speed","1"=>"Set LOW fan speed","99"=>"No action","98"=>"Set AUTO mode");
    var $validairdirection = array(0=>"Auto", 1=>"Direction 1", 2=>"Direction 2", 3=>"Direction 3", 4=>"Direction 4", 5=>"Direction 5", 6=>"Direction 6", 7=>"Direction 7");
    var $validfanspeeddelta = array("0.5"=>"0.5&deg; C","1.0"=>"1.0&deg; C","1.5"=>"1.5&deg; C","2.0"=>"2.0&deg; C","2.5"=>"2.5&deg; C","3.0"=>"3.0&deg; C");
    var $validintegratedelta_heat = array("0.5"=>"- 0.5&deg; C","1.0"=>"- 1.0&deg; C","1.5"=>"- 1.5&deg; C","2.0"=>"- 2.0&deg; C","2.5"=>"- 2.5&deg; C","3.0"=>"- 3.0&deg; C");
    var $validintegratedelta_cool = array("0.5"=>"+ 0.5&deg; C","1.0"=>"+ 1.0&deg; C","1.5"=>"+ 1.5&deg; C","2.0"=>"+ 2.0&deg; C","2.5"=>"+ 2.5&deg; C","3.0"=>"+ 3.0&deg; C");
	var $validhysteresis = array("0.1"=>"0.1&deg; C","0.2"=>"0.2&deg; C","0.3"=>"0.3&deg; C","0.4"=>"0.4&deg; C","0.5"=>"0.5&deg; C");
    
    /*!
     * Constructor override
     * If a temp configuration is available, load this one. If temp configuration
     * is not in place, create it.
     */    
    function __construct() {
		
      if (!file_exists(DRIVER_CONFIG_TEMP)) {
        copy(DRIVER_CONFIG_FILE,DRIVER_CONFIG_TEMP);
      }
      
      try {
		  
        $this->config = new SimpleXMLElement(file_get_contents(DRIVER_CONFIG_TEMP));
		
      } catch (Exception $e) {
		  
        // If exception occurs, restore current running configuration
        $this->lasterror = "Unable to parse current web configuration; replaced with current running configuration.";
        if (file_exists(DRIVER_CONFIG_FILE)) {
			
          copy(DRIVER_CONFIG_FILE,DRIVER_CONFIG_TEMP);
		  
        } else {
			
          // last resource is... copy the dist file
          copy(DRIVER_CONFIG_FILE.".dist",DRIVER_CONFIG_FILE);
          copy(DRIVER_CONFIG_FILE,DRIVER_CONFIG_TEMP);
		  
        }
		
        $this->config = new SimpleXMLElement(file_get_contents(DRIVER_CONFIG_TEMP));
      }
	  
	  $this->postInit();
	  
    }
  
    /*!
     * Verify if uploaded configuration is readable
     */
    public function parseUploadedConfiguration($filename) {
      try {
        $test = new SimpleXMLElement(file_get_contents($filename));
      } catch (Exception $e) {
        $this->lasterror = "Unable to parse uploaded configuration; the file will be ignored.";
        return false;
      }    
      return true;
    }
  
    /*!
     * Verify if temp configuration and running configuration differs
     */
    public static function isDirty() {
      if (file_exists(DRIVER_CONFIG_TEMP)) {
        return (md5_file(DRIVER_CONFIG_FILE) != md5_file(DRIVER_CONFIG_TEMP));
      } 
      return false;
    }
    
    public function getLastError() {
      return $this->lasterror;
    }
  
    function setGatewayIP($ip,$port = -1) {
      $this->config->gateways->gateway[0]->attributes()->ipaddress = $ip;
      if ($port != -1) {
        $this->config->gateways->gateway[0]->attributes()->port = $port;
      }
    }
    
    function setModel($model) {
      setAttribute($this->config->gateways->gateway[0],"type",$model);
      //$this->config->gateways->gateway[0]->attributes()->type = $model;
    }
      
    function setIdentifier($id) {
      setAttribute($this->config->gateways->gateway[0],"identifier",$id);
      //$this->config->gateways->gateway[0]->attributes()->type = $model;
    }
        
    function getGatewayIP() {
      return (string)$this->config->gateways->gateway[0]->attributes()->ipaddress;
    }
      
    function getIdentifier() {
      return (string)$this->config->gateways->gateway[0]->attributes()->identifier;
    }
    
    function getGatewayPort() {
      return (string)$this->config->gateways->gateway[0]->attributes()->port;
    }
    
    function getModel() {
      return (string)$this->config->gateways->gateway[0]->attributes()->type;
    }
    
    function getExpansionCard() {
      return (string)$this->config->gateways->gateway[0]->attributes()->ec;
    }    
    
    function getPreference($preference) {
      return (string)$this->config->preferences->$preference->attributes()->value;
    }    
    
    function setPreference($preference,$value) {
      if ($this->config->preferences->$preference->attributes()->value != "") {
        $this->config->preferences->$preference->attributes()->value = $value;
      } else {
        $item = $this->config->preferences->addChild($preference);
        $item->addAttribute('isSingle', 'true');
        $item->addAttribute('value', $value);
      }
    }

    // Join two containers, a->configured, b->discovered
    function joinZones($a,$b) {
      $ret = array();
      if (is_array($a)) {
        foreach($a as $item) {
          $insert = array(
            'GW'=>DAAC::idToDaikinUnit($item['group']), 
            //'MH'=>sprintf("%d (%s)"$item['zazb'],),
            'MH'=>sprintf("%s / %d",$item['ownservername'],$item['zazb']),
            'MHTEMP'=>'-',
            'TEMP'=>'-',
            'SETPOINT'=>'-',
            'MODE'=>'- / -',
            'MHMODE'=>'- / - / -',
            'MHSETPOINT'=>'-',
          );
          if (count($b) > 0) {
            foreach($b as $bkey=>$bitem) {
              if ($bitem['group'] == $item['group']) {
                if ($bitem['mhambient'] > 0) {
                  $insert['MHTEMP'] = sprintf("%.1f",$bitem['mhambient']);
                  $insert['MHMODE'] = $bitem['mhdrive']." / ".$bitem['mhmode']." / ".$bitem['mhfanspeed'];
                  $insert['MHSETPOINT'] = sprintf("%.1f",$bitem['mhsetpoint']);
                }
              
                $insert['TEMP'] = sprintf("%.1f",$bitem['ambient']);
                $insert['SETPOINT'] = sprintf("%.1f",$bitem['setpoint']);
                $insert['MODE'] = $bitem['drive']." / ".$bitem['mode']." / ".$bitem['fanspeed'];
                $b[$bkey]['done'] = 1;
              }
            }
          }
          $ret[$item['group']] = $insert;
        }
      }
      if (is_array($b)) {
        foreach($b as $bitem) {
          if ($bitem['done'] != 1) {
            $insert = array(
              'GW'=>DAAC::idToDaikinUnit($bitem['group']),
              'MH'=>'-',
              'MHTEMP'=>'-',
              'MHMODE'=>'- / -',
              'MHSETPOINT'=>'-',
              'TEMP'=>sprintf("%.1f",$bitem['ambient']),
              'SETPOINT'=>sprintf("%.1f",$bitem['setpoint']),
              'MODE'=>$bitem['drive'].' / '.$bitem['mode'].' / '.$bitem['fanspeed'],
            );        
            $ret[$bitem['group']] = $insert;
          }
        }
      }
      
      ksort($ret);
      return $ret;
    }

    function getOWNServerToString($ownserverid) {
      if ($ownserverid == 0) return "Local Bus";
      foreach($this->config->ownservers->children() as $item) {
        if ($item->getName() == 'ownserver' && $item->attributes()->id == $ownserverid) {
          //return sprintf("%s:%d",$item->attributes()->ipaddress,$item->attributes()->port);
          return (String)$item->attributes()->name;
        }
      }
      return "Unknown";
    }
    
    public function addOWNServer($ip,$port,$password,$name,$id = 0) {
    
      if (trim($name) == "") {
        $name = sprintf("%s:%d",trim($ip),intval($port));
      }
    
      if ($id == 0) {
        if ($this->isServerExistsIP($ip,$port)) {
          throw new Exception('My Home Gateway already exists');
        }
        $item = $this->config->ownservers->addChild('ownserver');
        $item->addAttribute('id', $this->getLastServerId());
        $item->addAttribute('ipaddress', trim($ip));
        $item->addAttribute('name', trim($name));
        $item->addAttribute('port', intval($port));
        $item->addAttribute('pwd', trim($password));
      } else {
        $item = $this->getOWNServer($id);
        if (isset($item->attributes()->name)) {
          $item->attributes()->name = trim($name);
        } else {
          $item->addAttribute('name', trim($name));
        }
        $item->attributes()->ipaddress = trim($ip);
        $item->attributes()->port = intval($port);
        $item->attributes()->pwd = trim($password);
      }
    }
    
    public function deleteOWNServer($ownserverid) {

      $position = 0;
      foreach($this->config->ownservers->children() as $item) {
        if ($item->getName() == 'ownserver' && $item->attributes()->id == $ownserverid) {
          // Delete all zones recursively
          $this->deleteZoneByServerId($ownserverid);
          // Finally delete zone
          
          $thisone = $this->config->xpath("//ownservers/ownserver[@id='$ownserverid']"); /* Useless but avoid segfault */
          unset($this->config->ownservers->ownserver->{$position});
          return;
        }
        $position++;
      }
    }    
    
    // Create an array of zones
    public function getOWNServers() {
      $items = array();
      foreach($this->config->ownservers->children() as $item) {
        $thisitem = array();
        foreach($item->attributes() as $key=>$value) {
          $thisitem[$key] = (string)$value;
        }
        $items[] = $thisitem;
      }
      return $items;
    }    
    
    public function getOWNServer($id) {
      $this->lasterror = '';
      foreach($this->config->ownservers->children() as $item) {
        if ($item->getName() == 'ownserver' && $item->attributes()->id == $id) {
          return $item;
        }
      }
      return null;    
    }   
    
    public function getOWNServersSelect() {
      $items = array();
      $items[0] = 'Local Bus';
      foreach($this->config->ownservers->children() as $item) {
        if ($item->getName() == 'ownserver') {
          $items[intval($item->attributes()->id)] = sprintf("%s (%s:%s)",$item->attributes()->name,$item->attributes()->ipaddress,$item->attributes()->port);
        }
      }
      return $items;
    }     
    
    // Create an array of zones
    function getZones($details = false) {
      $items = array();
      foreach($this->config->zones->children() as $item) {
        $zone = array();
        foreach($item->attributes() as $key=>$value) {
          $thisitem[$key] = (string)$value;
        }
        if ($details) {
          $thisitem['ownservername'] = $this->getOWNServerToString($item->attributes()->ownserver);
          $thisitem['s_hvacaddress'] = hvac::idToHVACUnit($thisitem['hvacaddress']);
          $thisitem['s_heating_mode'] = (string)$item->children()->heating->attributes()->mode;
          $thisitem['s_cooling_mode'] = (string)$item->children()->cooling->attributes()->mode;
        }
        $items[] = $thisitem;
      }
      return $items;
    }
    
    function getUsedZones($ownserver = 0,$exclude = -1) {
      $items = array();
      foreach($this->config->zones->children() as $item) {
        if (intval($item['probeaddress']) != $exclude and intval($item['ownserver']) == $ownserver) {
          $items[] = $item['probeaddress'];
        }
      }
      return $items;
    }
    
    function getUsedHVAC($exclude = -1) {
      $items = array();
      foreach($this->config->zones->children() as $item) {
        if (intval($item['hvacaddress']) != $exclude) {
          $items[] = $item['hvacaddress'];
        }
      }
      return $items;    
    }
    
    // Adds (or replace) a MH zone, heat|cool_array contains type/mode/defaultairdir
    public function addZone($id,$name,$hvacaddress,$ownserverid,$probeaddress,$tsarea,$tsaddress,$hvacfanauto,$probefan,$adjust,$heat_array = array(),$cool_array = array(),$lock_array = array(), $hvac_slaves_array = array()) {
      if (!$this->isServerExists($ownserverid) and $ownserverid != 0) {
        throw new Exception('My Home Gateway not exists.');
      }
      if ($block) { $block = 1; } else { $block = 0; }
      if (trim($name) == "") $name = sprintf("Zone_%02d",$hvacaddress);
      
      if ($id > 0) {
        $item = $this->getZone($id);
        
        if ($probeaddress != 0 && in_array($zone,$this->getUsedZones($ownserverid,$item->attributes()->probeaddress))) {
          throw new Exception('MyHome zone already in use.');
        }
        
        if (in_array($group,$this->getUsedHVAC($item->attributes()->hvacaddress))) {
          throw new Exception('HVAC address already in use.');
        }
        
        $item->attributes()->hvacid = 0;
        $item->attributes()->name = $name;
        $item->attributes()->probeaddress = $probeaddress;
        $item->attributes()->ownserver = $ownserverid;
        $item->attributes()->hvacaddress = $hvacaddress;
        $item->attributes()->probefanmode = ($probefan == 'yes' || (is_bool($probefan) && $probefan)) ? "yes" : "no";
        $item->attributes()->autofanspeed = ($hvacfanauto == 'yes' || (is_bool($hvacfanauto) && $hvacfanauto)) ? "yes" : "no";
        $item->attributes()->bacnetarea = intval($tsarea);
        $item->attributes()->bacnetaddress = intval($tsaddress);
        $item->attributes()->startupfanspeed = 0;
        setAttribute($item,'adjust',$adjust);
        $this->addZoneDetails($item,'heating',$heat_array);
        $this->addZoneDetails($item,'cooling',$cool_array);
        $this->addZoneDetails($item,'locking',$lock_array);
		$this->addZoneDetails($item,'hvacslaves', $hvac_slaves_array);
		
      } else {
      
        if ($probeaddress != 0 && in_array($zone,$this->getUsedZones($ownserverid))) {
          throw new Exception('MyHome zone already in use.');
        }
        
        if (in_array($hvacaddress,$this->getUsedHVAC())) {
          throw new Exception('HVAC address already in use.');
        }
      
        $item = $this->config->zones->addChild('zone');
        $item->addAttribute('id', $this->getLastZoneId());
        $item->addAttribute('hvacid',0);
        $item->addAttribute('name',$name);
        $item->addAttribute('probeaddress',$probeaddress);
        $item->addAttribute('ownserver',$ownserverid);
        $item->addAttribute('hvacaddress',$hvacaddress);
        $item->addAttribute('probefanmode',($probefan == 'yes' || (is_bool($probefan) && $probefan)) ? "yes" : "no");
        $item->addAttribute('autofanspeed',($hvacfanauto == 'yes' || (is_bool($hvacfanauto) && $hvacfanauto)) ? "yes" : "no");
        $item->addAttribute('bacnetarea',intval($tsarea));
        $item->addAttribute('bacnetaddress',intval($tsaddress));
        $item->addAttribute('startupfanspeed',0);
        setAttribute($item,'adjust',$adjust);
        
        $this->addZoneDetails($item,'heating',$heat_array);
        $this->addZoneDetails($item,'cooling',$cool_array);
        $this->addZoneDetails($item,'locking',$lock_array);
		$this->addZoneDetails($item,'hvacslaves', $hvac_slaves_array);
		
      }
    }
    
    private function addZoneDetails( $item, $section, $array_data ) {
		
		if ($item->$section) {
			
			foreach($array_data as $key=>$value) {
				
				if( isset( $item->$section->attributes()->$key ) ) {
					$item->$section->attributes()->$key = $value;
				} else {
					$item->$section->addAttribute( $key, $value );
				}				
			}
			
			$item->$section->attributes()->isSingle = "true";
			
		} else {
			
			$newitem = $item->addChild($section);
			foreach($array_data as $key=>$value) {
				$newitem->addAttribute($key,$value);
			}
			$newitem->addAttribute("isSingle","true");
		}
    }
    
    
    private function deleteZoneByServerId($ownserverid) {
      $this->lasterror = '';
      $position = 0; $deletes = array();
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone' && intval($item->attributes()->ownserver) == intval($ownserverid)) {
          $deletes[] = $position;
        }
        $position++;
      }
      
      $thisone = $this->config->xpath("//zones/zone[@ownserver='$ownserverid']"); /* Useless but avoid segfault */
      foreach(array_reverse($deletes) as $delete) {
        unset($this->config->zones->zone[$delete]);
      }
    }
    
    function deleteZone($itemid) {
      $this->lasterror = '';
      if (!$this->isZoneExists($itemid)) {
        $this->lasterror = 'Zone not exists';
        throw new Exception('Zone not exists.');
      }
      
      $position = 0;
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone' && $item->attributes()->id == $itemid) {
          $thisone = $this->config->xpath("//zones/zone[@id='$itemid']"); /* Useless but avoid segfault */
          unset($this->config->zones->zone[$position]);
          return;
        }
        $position++;
      }

    }
    
    private function isServerExists($ownserverid) {
      $this->lasterror = '';
      foreach($this->config->ownservers->children() as $item) {
        if ($item->getName() == 'ownserver' && $item->attributes()->id == $ownserverid) {
          return true;
        }
      }
      return false;
    }
    
    private function getLastServerId() {
      $this->lasterror = '';
      $lastid = 1;
      foreach($this->config->ownservers->children() as $item) {
        if ($item->getName() == 'ownserver') {
          if (intval($item->attributes()->id) >= $lastid) $lastid = intval($item->attributes()->id) + 1;
        }
      }
      return $lastid;    
    }
    
    private function getLastZoneId() {
      $this->lasterror = '';
      $lastid = 1;
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone') {
          if (intval($item->attributes()->id) >= $lastid) $lastid = intval($item->attributes()->id) + 1;
        }
      }
      return $lastid;    
    }    
    
    private function isServerExistsIP($ip,$port) {
      $this->lasterror = '';
      foreach($this->config->ownservers->children() as $item) {
        if ($item->getName() == 'ownserver' && $item->attributes()->ipaddress == $ip && $item->attributes()->port == $port) {
          return true;
        }
      }
      return false;
    }    
    
    private function isZoneExistsAddress($ownserverid,$zone) {
      $this->lasterror = '';
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone' && $item->attributes()->ownserver == $ownserverid && $item->attributes()->probeaddress == $zone) {
          return true;
        }
      }
      return false;
    }
    
    private function isZoneExists($id) {
      $this->lasterror = '';
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone' && $item->attributes()->id == $id) {
          return true;
        }
      }
      return false;
    }
	
    private function postInit() {
        
        //error_log( "postInit" );

        $testVariable = count( $this->config->preferences->setpoint_reached );
        //error_log( sprintf( "testVariable: %d", $testVariable ) );
        
        if( $testVariable > 0 ) {
            // 'setpoint_reached' xml node exists then have to remove it and create 2 new nodes:
            // 'heat_setpoint_reached' and 'cool_setpoint_reached'

            $elementsToRemove = array();
            
            foreach( $this->config->preferences->children() as $item ) {
                
                $name = $item->getName();
                
                //error_log( sprintf( "name: %s", $name ) );
                
                if( strcmp( $name, 'setpoint_reached' ) == 0 ) {
                    $elementsToRemove[] = $item;
                    //error_log( sprintf( "position: %d", $position ) );
                }
            }

            foreach( $elementsToRemove as $item ) {
                //error_log( sprintf( "unset: %s", $item->getName() ) );
                unset( $item[0] );
            }
            
            //error_log( 'heat_setpoint_reached 1' );
            $this->setPreference( 'heat_setpoint_reached', "1" );
            $this->setPreference( 'cool_setpoint_reached', "1" );

            $this->save( true );
        }
		
		/*
		<watchdogs isSingle="true">
		<watchdog timeout="2" buffer="10" alarm="3" reboot="1" ignore="6" modbus="15"/>
		</watchdogs>
		*/

		$testVariable = count( $this->config->watchdogs );

		if( $testVariable == 0 ) {

			$item = $this->config->addChild('watchdogs');
			$item->addAttribute('isSingle', 'true');

			$childItem = $item->addChild('watchdog');
			$childItem->addAttribute('timeout', 2);
			$childItem->addAttribute('buffer', 10);
			$childItem->addAttribute('alarm', 3);
			$childItem->addAttribute('reboot', 1);
			$childItem->addAttribute('ignore', 6);
			//$childItem->addAttribute('modbus', 15);

			$this->save( true );
		}
    }	
    
    /* New inUse<wildcard> functions */
    public function inUseProbeAddress($ownserverid,$zone,$excludezone = -1) {
      $this->lasterror = '';
      if ($zone == 0) return false;
      
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone' && $item->attributes()->ownserver == $ownserverid && $item->attributes()->probeaddress == $zone) {
          if (intval($item->attributes()->id) != $excludezone) return true;
        }
      }
      return false;
    }

    public function inUseTSAddress($bacnetarea,$bacnetaddress,$excludezone = -1) {
      $this->lasterror = '';
      if (($bacnetarea+$bacnetaddress) == 0) return false;
      
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone' && $item->attributes()->bacnetarea == $bacnetarea && $item->attributes()->bacnetaddress == $bacnetaddress) {
          if (intval($item->attributes()->id) != $excludezone) return true;
        }
      }
      return false;
    }    
    
    // public function inUseHVACAddress($hvacid,$hvacaddress,$excludezone = -1) {
      // $this->lasterror = '';
      // foreach($this->config->zones->children() as $item) {
        // if ($item->getName() == 'zone' && $item->attributes()->hvacid == $hvacid && $item->attributes()->hvacaddress == $hvacaddress) {
          // if (intval($item->attributes()->id) != $excludezone) return true;
        // }
      // }
      // return false;
    // }
    
		public function inUseHVACAddress($hvacid, $hvacaddress, $excludezone = -1) {
			
			$this->lasterror = '';
			foreach($this->config->zones->children() as $item) {
			
				if ($item->getName() == 'zone' && $item->attributes()->hvacid == $hvacid && $item->attributes()->hvacaddress == $hvacaddress) {
					
					if (intval($item->attributes()->id) != $excludezone) {
					
						return true;
					}
				}
			}

			//check if hvac master address has been already used in any defined hvac slaves address
			foreach($this->config->zones->children() as $item) {
			
				if ($item->getName() == 'zone' && $item->attributes()->hvacaddress != $hvacaddress) {
			
					foreach($item->children() as $subItem) {

						if ($subItem->getName() == 'hvacslaves') {

							if(isset($subItem->attributes()->hvacaddress_1)) {
			
								if (intval($subItem->attributes()->hvacaddress_1) == intval($hvacaddress)) {
									
									return true;
								}
							}

							if(isset($subItem->attributes()->hvacaddress_2)) {
			
								if (intval($subItem->attributes()->hvacaddress_2) == intval($hvacaddress)) {
									
									return true;
								}
							}

							if(isset($subItem->attributes()->hvacaddress_3)) {
			
								if (intval($subItem->attributes()->hvacaddress_3) == intval($hvacaddress)) {
									
									return true;
								}
							}

							if(isset($subItem->attributes()->hvacaddress_4)) {
								
								if (intval($subItem->attributes()->hvacaddress_4) == intval($hvacaddress)) {
									
									return true;
								}
							}

							if(isset($subItem->attributes()->hvacaddress_5)) {
			
								if (intval($subItem->attributes()->hvacaddress_5) == intval($hvacaddress)) {
									
									return true;
								}
							}
						}
					}
				}
			}

			return false;
		}

		//check if hvac slave address has been already used as master address
		public function checkSlaveHvacAddressNotInUseAsMasterHvacAddress($hvacid, $slaveHvacAddress, $excludezone = -1) {
			
			$this->lasterror = '';
			foreach($this->config->zones->children() as $item) {
				
				if ($item->getName() == 'zone' && $item->attributes()->hvacid == $hvacid && $item->attributes()->hvacaddress == $slaveHvacAddress) {
			
					if (intval($item->attributes()->id) != $excludezone) {
						
						return true;
					}
				}
			}
			return false;
		}

		public function checkHVACSlaveAddress($hvacid, $hvacaddress, $ind, $excludezone = -1) {
  		
			$this->lasterror = '';
			$trovato = false;
			$hvacMasterAddress;

			//cycle on tag 'zone', children of 'zones'
			foreach($this->config->zones->children() as $item) {
  			
				if ($item->getName() == 'zone' && $item->attributes()->hvacid == $hvacid) {

					//check the ID attribute of 'zone'
					if (intval($item->attributes()->id) != $excludezone) {
  					
						//it's a zone different from the current zone, so cycle the attributes of the child 'hvacslaves'
						//and check if exists the attribute hvacaddress_<n> (n = 1 to 5, with n=$hvacaddress)

						//cycle on children tag's 'zone'
						foreach($item->children() as $subItem) {
  						
							if ($subItem->getName() == 'hvacslaves') {
							
								if (intval($subItem->attributes()->hvacaddress_1) == intval($hvacaddress)) { return 11; }
								if (intval($subItem->attributes()->hvacaddress_2) == intval($hvacaddress)) { return 12; }
								if (intval($subItem->attributes()->hvacaddress_3) == intval($hvacaddress)) { return 13; }
								if (intval($subItem->attributes()->hvacaddress_4) == intval($hvacaddress)) { return 14; }
								if (intval($subItem->attributes()->hvacaddress_5) == intval($hvacaddress)) { return 15; }
							}
						}
  				
					} else {

						//looking for the hvac master address
						if (!$trovato) {
							
							$hvacMasterAddress = intval($item->attributes()->hvacaddress);
							$trovato = true;
						}

						//it's the same of current zone, check if there are duplicated addresses

						$sameAddressCounter = 0;

						foreach($item->children() as $subItem) {
  						
							if ($subItem->getName() == 'hvacslaves') {

								// compare must be performed on address different from the current (e.g if current = 2, must compare 1,3,4,5)
								if(!(intval($ind) == 1)) {
							  
									if (intval($subItem->attributes()->hvacaddress_1) == intval($hvacaddress)) {
										$sameAddressCounter++;
									}
								}

								if(!(intval($ind) == 2)) {
								  
									if (intval($subItem->attributes()->hvacaddress_2) == intval($hvacaddress)) {
										$sameAddressCounter++;
									}
								}

								if(!(intval($ind) == 3)) {
									
									if (intval($subItem->attributes()->hvacaddress_3) == intval($hvacaddress)) {
										$sameAddressCounter++;
									}
								}

								if(!(intval($ind) == 4)) {
									
									if (intval($subItem->attributes()->hvacaddress_4) == intval($hvacaddress)) {
										$sameAddressCounter++;
									}
								}

								if(!(intval($ind) == 5)) {
									
									if (intval($subItem->attributes()->hvacaddress_5) == intval($hvacaddress)) {
										$sameAddressCounter++;
									}
								}
							}
						}

						if ($sameAddressCounter > 0 ) { return ($sameAddressCounter+30); }
					}
				}
			}

			//check if any other hvac slave addresses are equal to the master address
			if ($hvacMasterAddress == intval($hvacaddress)) {
				return 40;
			}

			return 0;
		}
    
    //public function getZone($ownserverid,$zone) {
    //  $this->lasterror = '';
    //  foreach($this->config->zones->children() as $item) {
    //    if ($item->getName() == 'zone' && $item->attributes()->ownserver == $ownserverid && $item->attributes()->zazb == $zone) {
    //      return $item;
    //    }
    //  }
    //  return null;    
    //}
    
    /* Convert integer id to HVAC-specific id */
    public static function idToHVACUnit($id) {
      return sprintf("%02d-%02d",floor($id/16),$id % 16);
    }


    public function getZone($zoneid) {
      $this->lasterror = '';
      foreach($this->config->zones->children() as $item) {
        if ($item->getName() == 'zone' && $item->attributes()->id == $zoneid) {
          return $item;
        }
      }
      return null;    
    }

    // Save current configuration. Default (commit=false) save only temporary
    // configuration file. If commit is set, current temp configuration is copied
    // over running configuration
    function save($commit = false) {
      $this->lasterror = '';
      file_put_contents(DRIVER_CONFIG_TEMP,$this->config->asXML());
      if ($commit) {
        copy(DRIVER_CONFIG_TEMP,DRIVER_CONFIG_FILE);
      }
    }
   
    // Overwrites temp configuration with running configuration
    function cancel() {
      $this->lasterror = '';  
      copy(DRIVER_CONFIG_FILE,DRIVER_CONFIG_TEMP);
      $this->config = new SimpleXMLElement(file_get_contents(DRIVER_CONFIG_TEMP));
    }
    
    /* Restore clean configuration */
    function restore() {
      $this->lasterror = '';  
      copy(DRIVER_CONFIG_FILE.".dist",DRIVER_CONFIG_FILE);
      copy(DRIVER_CONFIG_FILE,DRIVER_CONFIG_TEMP);
      $this->config = new SimpleXMLElement(file_get_contents(DRIVER_CONFIG_TEMP));
    }    
    
  }

  function createRange($prefix,$from,$to,$excludedrange = array(),$hidemessage = "") {
    $ret = array();
    if ($prefix != "") { $prefix .= " "; };
    for ($i = $from; $i <= $to; $i++) {
      if (in_array($i,$excludedrange)) {
        // if in excluded range... display (with $hidemessage) or not display
        if ($hidemessage != "") {
          $ret[$i] = sprintf("%s%d %s",$prefix,$i,$hidemessage);
        }
      } else {
        $ret[$i] = sprintf("%s%d",$prefix,$i);
      }
      
    }
    return $ret;
  }
  
  function createRangeEx($prefix,$from,$to,$excludedrange = array(),$hidemessage = "") {
    $ret = array();
    if ($prefix != "") { $prefix .= " "; };
    for ($i = $from; $i <= $to; $i++) {
      if (in_array($i,$excludedrange)) {
        // if in excluded range... display (with $hidemessage) or not display
        if ($hidemessage != "") {
          $ret[$i] = sprintf("%s%s %s",$prefix,hvac::idToHVACUnit($i),$hidemessage);
        }
      } else {
        $ret[$i] = sprintf("%s%s",$prefix,hvac::idToHVACUnit($i));
      }
      
    }
    return $ret;
  }  

  class htmlutils {
    static function select($name,$description,$values,$default = "") {
      printf('<label for="%s">%s</label><select name="%s" id="%s">',$name,$description,$name,$name);
      foreach ($values as $key=>$value) { 
        if ($key == $default) {
          printf('<option value="%s" selected>%s</option>',$key,$value);
        } else {
          printf('<option value="%s">%s</option>',$key,$value);
        }
      }
      printf('</select>');
    }
    
  }

  function setAttribute($collection,$attribute,$value) {
    if (trim($value) == '') $value = "\0";  
    if (isset($collection->attributes()->$attribute)) {
      $collection->attributes()->$attribute = $value;
    } else {
      $collection->addAttribute($attribute,$value);
    }
  }

?>