<? 
  require_once($_SERVER['BASEPATH'].DIRECTORY_SEPARATOR.'common/base.php');
  require_once("_common.php");
  header('Content-type: application/json');

  $ret = array(); $errors = array();
  $conf = new hvac();
	$prefs = array( "heat_integratedeviation",
				  "cool_integratedeviation",
				  "heat_rangepid",
				  "cool_rangepid",
				  "ambient_reference",
				  "protection_mode",
				  "heat_setpoint_reached",
				  "cool_setpoint_reached",
				  "bacnetserver_port",
				  "heat_hysteresis",
				  "cool_hysteresis");
  
  switch(strtolower($_REQUEST['action'])) {
    
	case 'status.dirty':
		$ret['dirty'] = hvac::isDirty();
	break;
	
	case 'status':
      
		$shared = new mhShared();
		$readed = json_decode( $shared->read( 'zones' ), true ); 
		if( count( $readed ) > 0 ) {
			$ret['zones'] = $readed;
		} else {
			$ret['zones'] = array();
		}

		$readed = json_decode( $shared->read( 'ownservers' ), true ); 
		$readed[] = array( 'id' => '0', 'name' => 'Local Bus' );
		if( count( $readed ) > 0 ) {
			$ret['ownservers'] = $readed;
		} else {
			$ret['ownservers'] = array();
		}

		$gateway = json_decode( $shared->read( 'gateway' ), true ); 
		if( count( $gateway ) > 0 ) {
			$ret['gateway'] = $gateway;
		} else {
			$ret['gateway'] = array();
		}

		$ret['licensed'] = json_decode($shared->read('licensed'),true);

	break;
  
    case 'zone.list':
      $ret['list'] = $conf->getZones(true);
      $ret['dirty'] = hvac::isDirty();      
	break;
	
	case 'zone.save':
		
		if (intval($_REQUEST['locking_button_cenplus']) > 2047 || intval($_REQUEST['locking_button_cenplus']) < 0) {
			$ret = array('success'=>false,'message'=>"Invalid locking CEN+ address"); break;
		}
		
		if (intval($_REQUEST['locking_cen_b']) > 9 || intval($_REQUEST['locking_cen_b']) < 0) {
			$ret = array('success'=>false,'message'=>"Invalid locking CEN BUS address"); break;
		}
      
		if (intval($_REQUEST['locking_cen_a']) > 15 || intval($_REQUEST['locking_cen_a']) < 0) {
			$ret = array('success'=>false,'message'=>"Invalid locking CEN A address"); break;
		}
      
		if (intval($_REQUEST['locking_cen_pl']) > 15 || intval($_REQUEST['locking_cen_pl']) < 0) {
			$ret = array('success'=>false,'message'=>"Invalid locking CEN PL address"); break;
		}
    
		if (intval($_REQUEST['locking_button_off']) > 99 || intval($_REQUEST['locking_button_off']) < 0) {
			$ret = array('success'=>false,'message'=>"Invalid locking OFF button"); break;
		}
      
		if (intval($_REQUEST['locking_button_on']) > 99 || intval($_REQUEST['locking_button_on']) < 0) {
			$ret = array('success'=>false,'message'=>"Invalid locking ON button"); break;
		}
      
		if (intval($_REQUEST['locking_button_temp']) > 99 || intval($_REQUEST['locking_button_temp']) < 0) {
			$ret = array('success'=>false,'message'=>"Invalid locking Temporary button"); break;
		}

		// Verify if TS A/PL is in use
		if ($conf->inUseProbeAddress(intval($_REQUEST['ownserver']),intval($_REQUEST['probeaddress']),intval($_REQUEST['id']))) {
			$ret = array('success'=>false,'message'=>"Probe address already in use"); break;
		}

		if ($conf->inUseTSAddress(intval($_REQUEST['bacnetarea']),intval($_REQUEST['bacnetaddress']),intval($_REQUEST['id']))) {
			$ret = array('success'=>false,'message'=>"TS address already in use"); break;
		}
      
		if ($conf->inUseHVACAddress(0,intval($_REQUEST['hvacaddress']),intval($_REQUEST['id']))) {
			$ret = array('success'=>false,'message'=>"HVAC address already in use"); break;
		}
		
			// +FEAT. HVAC Master/Slaves
			$hvacSlaveAddresses = array(1 => intval($_REQUEST['slave_1']), intval($_REQUEST['slave_2']), intval($_REQUEST['slave_3']), intval($_REQUEST['slave_4']), intval($_REQUEST['slave_5']));
			$hvacSlaveAddressInUse = false;

			// check if hvac slave addresses has been already used in hvac master address
			foreach ($hvacSlaveAddresses as $i => $value) {
				
				if( $hvacSlaveAddresses[$i] > -1) {

					if ($conf->checkSlaveHvacAddressNotInUseAsMasterHvacAddress(0,$hvacSlaveAddresses[$i],intval($_REQUEST['id']))) {
            
						$ret = array('success'=>false,'message'=>"HVAC address ".hvac::idToHVACUnit($hvacSlaveAddresses[$i])." already in use in other zone");
						$hvacSlaveAddressInUse = true;
						break;
					}

					// check if hvac slave addresses has been already used in other zones
					$returnValue = $conf->checkHVACSlaveAddress(0,$hvacSlaveAddresses[$i],$i,intval($_REQUEST['id']));
          
					if ($returnValue > 9 && $returnValue < 16) {
            
						$ret = array('success'=>false,'message'=>"HVAC slave address ".hvac::idToHVACUnit($hvacSlaveAddresses[$i])." already in use in different zone");
						$hvacSlaveAddressInUse = true;
						break;
						
					} else if($returnValue > 30 && $returnValue < 40) {
						
						$ret = array('success'=>false,'message'=>"HVAC slave address ".hvac::idToHVACUnit($hvacSlaveAddresses[$i])." already in use in same zone");
						$hvacSlaveAddressInUse = true;
						break;
						
					} else if($returnValue == 40) {
						
						$ret = array('success'=>false,'message'=>"HVAC slave address ".hvac::idToHVACUnit($hvacSlaveAddresses[$i])." duplicate of HVAC master address in use in same zone");
						$hvacSlaveAddressInUse = true;
						break;
						
					} else {
						
						// nop
					}
				}
			}

			if ($hvacSlaveAddressInUse) {
				break;
			}
			// -FEAT. HVAC Master/Slaves		

		if( ( intval( $_REQUEST['bacnetarea'] ) != 0 && intval( $_REQUEST['bacnetaddress'] ) == 0) || ( intval( $_REQUEST['bacnetarea'] ) == 0 && intval( $_REQUEST['bacnetaddress'] ) != 0 ) ) {
					
				$ret = array('success'=>false,'message'=>"Wrong TS address");
				break;
		}
    
		try {
			$conf->addZone(	intval($_REQUEST['id']),trim($_REQUEST['name']),intval($_REQUEST['hvacaddress']),intval($_REQUEST['ownserver']),intval($_REQUEST['probeaddress']),intval($_REQUEST['bacnetarea']),intval($_REQUEST['bacnetaddress']),trim($_REQUEST['autofanspeed']),trim($_REQUEST['probefanmode']),trim($_REQUEST['adjust']),
							array('type'=>trim($_REQUEST['heating_type']),'mode'=>trim($_REQUEST['heating_mode'])),
							array('type'=>trim($_REQUEST['cooling_type']),'mode'=>trim($_REQUEST['cooling_mode'])),
							array('cenaddress'=>sprintf("%d-%d-%d",intval($_REQUEST['locking_cenaddress_b']),intval($_REQUEST['locking_cenaddress_a']),intval($_REQUEST['locking_cenaddress_pl'])),'cenplusaddress'=>intval($_REQUEST['locking_cenplusaddress']),'buttonlock'=>intval($_REQUEST['locking_buttonlock']),'buttonunlock'=>intval($_REQUEST['locking_buttonunlock']),'buttontemporary'=>intval($_REQUEST['locking_buttontemporary'] ) ),
							array('hvacaddress_1' => intval($_REQUEST['slave_1']), 'hvacaddress_2' => intval($_REQUEST['slave_2']), 'hvacaddress_3' => intval($_REQUEST['slave_3']), 'hvacaddress_4' => intval($_REQUEST['slave_4']), 'hvacaddress_5' => intval($_REQUEST['slave_5'])));
			$conf->save();
		} catch (Exception $e) {
			$ret = array('success'=>false,'message'=>$e->getMessage());
			break;
		}
      
		$ret = array('success'=>true,'message'=>"Zone saved");
	break;
    
	case 'zone.load':
	
		if (intval($_REQUEST['id']) <= 0) {
			/* New zone template */
			$ret = array(
			  'success'=>true,'message'=>'',
			  'id'=>'0','name'=>'',
			  'ownserver'=>'0','probeaddress'=>'0',
			  'bacnetadrea'=>'0','bacnetaddress'=>'0',
			  'hvacaddress'=>'0','ownserver'=>'0','probeaddress'=>'0','bacnetarea'=>'0','bacnetaddress'=>'0',
			  'autofanspeed'=>'no','probefanmode'=>'yes', 'adjust'=>'NONE',
			  'heating_type'=>'VIRT','heating_mode'=>'SINGLE',
			  'cooling_type'=>'VIRT','cooling_mode'=>'SINGLE',
			  'locking_cenaddress_b'=>'0','locking_cenaddress_a'=>'0','locking_cenaddress_pl'=>'0','locking_cenplusaddress'=>'0','locking_buttonlock'=>'-1','locking_buttonunlock'=>'-1','locking_buttontemporary'=>'-1',          
			'slave_1'=>'-1','slave_2'=>'-1','slave_3'=>'-1','slave_4'=>'-1','slave_5'=>'-1');
			break;
		}
		
		function array_key_prefix($array,$prefix) {
        
			$out = array();
			foreach($array as $key=>$item) {
				$out[$prefix.$key] = $item;
			}
			return $out;
		};
		
		// +FEAT. HVAC Master/Slaves
		function array_key_prefix_hvac_slaves($array, $prefix) {

			// array initializing
			$out = array('slave_1' => '-1', 'slave_2' => '-1', 'slave_3' => '-1', 'slave_4' => '-1', 'slave_5' => '-1');

			foreach($array as $key=>$item) {
				//$key =  hvacaddress_<n> from 0 to 63
				//$item =  from 0 to 63
				//get the number n from the string hvacaddress_<n>
				$pos = strpos( $key, "_" );
				$key = substr( $key, ($pos + 1) );
				$out[$prefix.$key] = $item;
			}
			
			return $out;
		};
		// -FEAT. HVAC Master/Slaves		
      
		/* base zone info */
		$ret = current($conf->getZone(intval($_REQUEST['id']))->attributes());
      
		/* Upgrade from previous version */
		if (!isset($ret['adjust'])) $ret['adjust'] = 'NONE';
      
		/* heating zone info */
		$ret = array_merge($ret,array_key_prefix(current($conf->getZone(intval($_REQUEST['id']))->heating->attributes()),'heating_'));
		
		/* cooling zone info */
		$ret = array_merge($ret,array_key_prefix(current($conf->getZone(intval($_REQUEST['id']))->cooling->attributes()),'cooling_'));
      
		/* locking zone info */
		$ret = array_merge($ret,array_key_prefix(current($conf->getZone(intval($_REQUEST['id']))->locking->attributes()),'locking_'));
		
		/* hvac slaves */
		$ret = array_merge($ret,array_key_prefix_hvac_slaves(current($conf->getZone(intval($_REQUEST['id']))->hvacslaves->attributes()),'slave_'));
		
	break;
	
    case 'zone.remove':
    case 'zone.delete':
      if (intval($_REQUEST['id']) <= 0) {
        $ret = array('success'=>false,'message'=>"Invalid server identifier");
        break;
      }    
      if (is_null($conf->getZone(intval($_REQUEST['id'])))) {
        $ret = array('success'=>false,'message'=>"Server does not exist");
        break;
      }      
      
      $conf->deleteZone(intval($_REQUEST['id']));
      $conf->save();
      $ret = array('success'=>true,'message'=>"Deleted");
      break;
    case 'ownserver.remove':
    case 'ownserver.delete':
      if (intval($_REQUEST['id']) <= 0) {
        $ret = array('success'=>false,'message'=>"Invalid server identifier");
        break;
      }
      if (is_null($conf->getOWNServer(intval($_REQUEST['id'])))) {
        $ret = array('success'=>false,'message'=>"Zone does not exist");
        break;
      }
      
      $conf->deleteOWNServer(intval($_REQUEST['id']));
      $conf->save();
      $ret = array('success'=>true,'message'=>"Deleted");
      break;
  
    case 'ownserver.list':
      $ret['list'] = $conf->getOWNServers();
      $ret['dirty'] = hvac::isDirty();         
      break;
    case 'ownserver.load':
      if (intval($_REQUEST['id']) <= 0) {
        $ret = array(
          'success'=>true,
          'message'=>'',
          "id"=>"0",
          "ipaddress"=>"127.0.0.1",
          "port"=>"20000",
          "pwd"=>"12345",
          "name"=>''
        );
        break;
      } 
      $ret = current($conf->getOWNServer(intval($_REQUEST['id']))->attributes());
      break;
    case 'ownserver.save':
      if (intval($_REQUEST['id']) < 0) {
        $ret = array('success'=>false,'message'=>'Invalid server identifier');
        break;
      }
      if (intval($_REQUEST['port']) <= 1024 || intval($_REQUEST['port']) >= 65535) {
        $ret = array('success'=>false,'message'=>'Invalid TCP port');
        break;
      }      
      if ((strlen(trim($_REQUEST['pwd'])) > 6 || strlen(trim($_REQUEST['pwd'])) < 4) && strlen(trim($_REQUEST['pwd'])) != 0) {
        $ret = array('success'=>false,'message'=>'Invalid password, valid length is between 4 and 6');
        break;
      }      
      
      $address = trim($_REQUEST[$_REQUEST['ip_or_name']]);
      if (trim($address) == "" || !in_array($_REQUEST['ip_or_name'],array('ipaddress','nameaddress'))) {
        $ret = array('success'=>false,'message'=>'Invalid address');
        break;
      }
      
      if (eregi('^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}(/[0-9]{1,2}){0,1}$', $address) == 1 && $_REQUEST['ip_or_name'] == 'nameaddress') {
        $ret = array('success'=>false,'message'=>'Invalid usage of Name Address field '.$address);
        break;
      }
      
      try {
        $conf->addOWNServer($address,$_REQUEST['port'],$_REQUEST['pwd'],$_REQUEST['name'],intval($_REQUEST['id']));
        $conf->save();
      } catch (Exception $e) {
        $ret = array('success'=>false,'message'=>$e->getMessage());
        break;
      }
      
      $ret = array('success'=>true,'message'=>"Saved!");
      break;  
    case 'gateway.save':      
      /* Validate IP without regexp because this PHP does not works */
      $ips = split('\.', $_REQUEST['ip_address']);
      if (count($ips) == 4) {
        for ($i = 0; $i < count($ips); $i++) {
          if (intval($ips[$i]) >= 255 || intval($ips[$i]) <= 0) {
            $errors[] = "Invalid Gateway IP Address";
            break;
          }
        }
        $conf->setGatewayIP(trim($_REQUEST['ip_address']));
        $conf->setModel(trim($_REQUEST['model']));
        $conf->setIdentifier(intval(trim($_REQUEST['identifier'])));  
        $conf->save();
      } else {
        $errors[] = "Invalid Gateway IP Address";
      }
      if (count($errors) == 0) {
        $ret = array('success'=>true,'message'=>"Saved!");
      } else {
        $ret = array('success'=>false,'message'=>"Generic error");
      }
      $ret['dirty'] = hvac::isDirty();         
      break;
    case 'prefs.save':
      /* Do not validate select, only textboxes */
      try {
        function savepreference($key) {
          global $conf;
          if (trim($_REQUEST[$key]) != '') $conf->setPreference($key,trim($_REQUEST[$key]));
        }
        /* Ignore model, save IP */
        
        foreach($prefs as $pref) {
          savepreference($pref);
        }
        $conf->save();
        $ret = array('success'=>true,'message'=>"Saved!");
      } catch (Exception $e) {
        $ret = array('success'=>false,'message'=>"Generic error");
        break;
      }
      $ret['dirty'] = hvac::isDirty();         
      break;
    case 'gateway.load':
      $ret['ip_address'] = $conf->getGatewayIP();
      $ret['identifier'] = $conf->getIdentifier();
                             
      foreach($prefs as $pref) {
        $ret[$pref] = $conf->getPreference($pref);
      }
      break;
  
    default:
      $ret = array('success'=>false,'message'=>"Invalid request");
      break;
  }
  echo json_encode($ret);

?>