/*
 * This class connects MH to generic HVAC driver
 */
var WATCHDOG = (function () {

    /*
    sysinfo.xml sample

    <SYSINFO>
        <PAR0>00-03-50-99-16-D7</PAR0>
        <PAR1>192.168.148.108</PAR1>
        <PAR2>008F27D4</PAR2>
        <PAR4>Camera 8</PAR4>
        <OBJ_MOD>5.0.10</OBJ_MOD>
        <VER>3.2.8</VER>
        <BOOT_VER>2.0.1</BOOT_VER>
        <FLASH_STATE>OK</FLASH_STATE>
        <FLASH_COUNT>0</FLASH_COUNT>
        <GW>192.168.148.1</GW>
        <MASK>255.255.255.0</MASK>
        <UC_98>108</UC_98>
        <UC_150>108</UC_150>
        <UC_250>108</UC_250>
        <PRJ_ID>F1F00D63-929E-444D-983B-1D0F6BF5ECB9</PRJ_ID>
        <APT_ID>00000000-0000-4001-B000-000000100008</APT_ID>
        <CONF_VERS>3.2.1</CONF_VERS>
        <CONNECTION>
            <OPEN_MONITOR_SOCKET>
                <NUMBER>2</NUMBER>
                <IP_DEST>192.168.148.100</IP_DEST>
                <STATE>CONNECTED</STATE>
            </OPEN_MONITOR_SOCKET>
            <OPEN_MONITOR_SOCKET>
                <NUMBER>4</NUMBER>
                <IP_DEST>192.168.147.155</IP_DEST>
                <STATE>CONNECTED</STATE>
            </OPEN_MONITOR_SOCKET>
            <OPEN_COMMAND_SOCKET>
                <NUMBER>3</NUMBER>
                <IP_DEST>192.168.148.100</IP_DEST>
                <STATE>CONNECTED</STATE>
            </OPEN_COMMAND_SOCKET>
            <OPEN_COMMAND_SOCKET>
                <NUMBER>5</NUMBER>
                <IP_DEST>192.168.147.155</IP_DEST>
                <STATE>CONNECTED</STATE>
            </OPEN_COMMAND_SOCKET>
        </CONNECTION>
        <V_BUS>27.0</V_BUS>
    </SYSINFO>
    */

    // constructor
    var drv = function () {

        var prefix = "M-WD";
        var ownGatewaysWatchDogs = [];

        // setting watch dog default values
        var ALARM = 3;
        var REBOOT = 1;
        var IGNORE = 6;
        var BUFFER = 10;
        var TIMEOUT = 0;
        //this.MODBUS = 15;

        var timerCounter = 0;

        // constants
        var MONITOR = 0;
        var COMMANDS = 1;

        var monitorOpenXmlTagString = "<OPEN_MONITOR_SOCKET>";
        var monitorCloseXmlTagString = "</OPEN_MONITOR_SOCKET>";

        var commandOpenXmlTagString = "<OPEN_COMMAND_SOCKET>";
        var commandCloseXmlTagString = "</OPEN_COMMAND_SOCKET>";

        var stateOpenXmlTagString = "<STATE>";
        var stateCloseXmlTagString = "</STATE>";

        var timerIndex;

        // default values
        //this.connectionStatus = [true, true];   // [TRUE, FALSE]

        //this.modbusInterfaceConnectionGuard = new mhTimer();
        //this.modbusTimerUsable = false;

        var rebootTimer = new mhTimer();
        rebootTimer.setInterval(1000, true); /* single shot timer */
        rebootTimer.setAction(function () { mhOWN.exit(); });

        this.setAlarm = function (value) {

            ALARM = value;
            logger.info("%s setAlarm watchdog alarm config value: %d".sprintf(prefix, ALARM));
        }

        this.setTimeout = function (value) {

            TIMEOUT = value;
            logger.info("%s setTimeout watchdog timeout config value: %d".sprintf(prefix, TIMEOUT));
        }

        this.setReboot = function (value) {

            REBOOT = value;
            logger.info("%s setReboot watchdog reboot config value: %d".sprintf(prefix, REBOOT));
        }

        this.setIgnore = function (value) {

            IGNORE = value;
            logger.info("%s setIgnore watchdog ignore config value: %d".sprintf(prefix, IGNORE));
        }

        this.setBuffer = function (value) {

            BUFFER = value;
            logger.info("%s setBuffer watchdog buffer config value: %d".sprintf(prefix, BUFFER));
        }

        var matchingResults = 0;

        this.endOfConfig = function () {

            try {

                logger.info("%s endOfConfig watchdog timeout config value: %d".sprintf(prefix, TIMEOUT));
                logger.info("%s endOfConfig watchdog alarm config value: %d".sprintf(prefix, ALARM));
                logger.info("%s endOfConfig watchdog reboot config value: %d".sprintf(prefix, REBOOT));
                logger.info("%s endOfConfig watchdog ignore config value: %d".sprintf(prefix, IGNORE));
                logger.info("%s endOfConfig watchdog buffer config value: %d".sprintf(prefix, BUFFER));
                //logger.info("%s endOfConfig watchdog modbus config value: %d".sprintf(prefix, this.MODBUS));
                //logger.info("%s endOfConfig watchdog modbusTimerUsable: %s".sprintf(prefix, this.modbusTimerUsable));

                // check if there are any own servers
                if ((Object.keys(gwStatus).length > 0) && (TIMEOUT > 0)) {

                    for (var gwId in gwStatus) {

                        logger.info("%s endOfConfig gwId: %d".sprintf(prefix, gwId));

                        var address = gwStatus[gwId]['address'];    // format("%s (%s:%d)",own.name,own.ipaddress,own.port);
                        var m = address.lastIndexOf("(");
                        var n = address.lastIndexOf(":");

                        var ipAddress = address.substring(m + 1, n);

                        logger.info("%s endOfConfig ipAddress: %s".sprintf(prefix, ipAddress));

                        ownGatewaysWatchDogs[gwId] = {};
                        ownGatewaysWatchDogs[gwId].ipAddress = ipAddress;
						ownGatewaysWatchDogs[gwId].connectionStatusHistory = [];
                        ownGatewaysWatchDogs[gwId].debugXml = [0, 0];       // [0, 1, ..., REBOOT]
                        ownGatewaysWatchDogs[gwId].analyze = [true, true];  // [TRUE, FALSE]	vale FALSE immediatamente dopo l'invio di un debug.xml quando 
                        ownGatewaysWatchDogs[gwId].ignored = [0, 0];        // [0, 1, ..., IGNORE]
						ownGatewaysWatchDogs[gwId].httpclient = new mhHTTPClient();
						ownGatewaysWatchDogs[gwId].httpclient.setTimeout(TIMEOUT * 60 * 1000);
						ownGatewaysWatchDogs[gwId].connections = gwStatus[gwId]['connections'];
						
						ownGatewaysWatchDogs[gwId].connectionStatusHistory.push(new Queue());
						ownGatewaysWatchDogs[gwId].connectionStatusHistory.push(new Queue());

						//logger.info("%s endOfConfig ownGatewaysWatchDogs[%d].connectionStatusHistory[%d]: %s".sprintf(prefix, gwId, MONITOR, ownGatewaysWatchDogs[gwId].connectionStatusHistory[MONITOR]));
						//logger.info("%s endOfConfig ownGatewaysWatchDogs[%d].connectionStatusHistory[%d]: %s".sprintf(prefix, gwId, COMMANDS, ownGatewaysWatchDogs[gwId].connectionStatusHistory[COMMANDS]));
                    }

                    if (TIMEOUT > 0) {

                        logger.info("%s adding watchDogTimeoutCallback callback".sprintf(prefix));
                        timerIndex = timerManager.add(new TimerObject(60, "watchDogTimeoutCallback", watchDogTimeoutCallback, false, 9999));
                        timerManager.start(timerIndex);
                    }

                } else {

                    if (Object.keys(gwStatus).length == 0) {

                        logger.warning("%s endOfConfig WARNING!! watch dog will not monitor own servers connection statuses due to no own servers defined".sprintf(prefix));

                    } else if (TIMEOUT == 0) {

                        logger.warning("%s endOfConfig WARNING!! watch dog will not monitor own servers connection statuses due to timeout parameter set to %d".sprintf(prefix, TIMEOUT));

                    } else {

                        // should never arrive here
                        logger.warning("%s endOfConfig WARNING!! watch dog will not monitor own servers connection statuses due to unknown reasons".sprintf(prefix));
                    }
                }

            } catch (ex) {

                logger.error("%s endOfConfig error: %s".sprintf(prefix, ex));
            }
        }

        function watchDogTimeoutCallback() {

            logger.info("%s watchDogTimeoutCallback".sprintf(prefix));

            for (var gwId in gwStatus) {

                timerCallback(gwId);
            }
        }

        function indexes(source, find) {

            if (!source) {

                return [];
            }

            // if find is empty string return all indexes.
            if (!find) {

                // or shorter arrow function:
                // return source.split('').map((_,i) => i);
                return source.split('').map(function (_, i) { return i; });
            }

            var result = [];
            for (i = 0; i < source.length; ++i) {

                // If you want to search case insensitive use 
                // if (source.substring(i, i + find.length).toLowerCase() == find) {
                if (source.substring(i, i + find.length) == find) {
                    result.push(i);
                }
            }
            return result;
        }

        function timerCallback(id) {

            logger.info("%s timerCallback id: %d".sprintf(prefix, id));

            var logHeader = "%s[gw:%02d,ip:%s] timerCallback".sprintf(prefix, id, ownGatewaysWatchDogs[id].ipAddress);

            try {

                //check own gateway status
                var monitorConnectionsStatus = true;
                var commandConnectionsStatus = true;
                var connections = ownGatewaysWatchDogs[id].connections;

                var httpMessage = "http://%s/sysinfo.xml".sprintf(ownGatewaysWatchDogs[id].ipAddress);
                var response = ownGatewaysWatchDogs[id].httpclient.getURL(httpMessage);

                logger.info("%s querying own gateway status by http message: %s".sprintf(logHeader, httpMessage));

                if (response.code == 200) {

                    var body = response.body;
                    logger.debug("%s http response code: %d".sprintf(logHeader, response.code));
                    logger.debug("%s response body: %s".sprintf(logHeader, response.body));

                    var commandStartIndexes = [];
                    var commandStopIndexes = [];

                    // MONITOR CONNECTION STATUS

                    var monitorStartIndexes = indexes(body, monitorOpenXmlTagString);   // "<OPEN_MONITOR_SOCKET>"
                    var monitorStopIndexes = indexes(body, monitorCloseXmlTagString);   // "</OPEN_MONITOR_SOCKET>"

                    //logger.debug("%s monitorStartIndexes: %s".sprintf(logHeader, monitorStartIndexes));
                    //logger.debug("%s monitorStopIndexes: %s".sprintf(logHeader, monitorStopIndexes));

                    if (monitorStartIndexes.length == connections && monitorStopIndexes.length == connections) {

                        //logger.debug("%s monitorStartIndexes.length: %d equal to monitorStopIndexes.length: %d".sprintf(logHeader, monitorStartIndexes.length, monitorStopIndexes.length));

                        var objMonitorConnections = [];
                        for (var t = 0; t < connections; t++) {

                            objMonitorConnections.push({ start: monitorStartIndexes[t] + monitorOpenXmlTagString.length, stop: monitorStopIndexes[t], stringPart: body.substring(monitorStartIndexes[t] + monitorOpenXmlTagString.length, monitorStopIndexes[t]), connectionStatus: "" });
                        }

                        //objMonitorConnections.push({ start: monitorStartIndexes[0] + monitorOpenXmlTagString.length, stop: monitorStopIndexes[0], stringPart: body.substring(monitorStartIndexes[0] + monitorOpenXmlTagString.length, monitorStopIndexes[0]), connectionStatus: "", match: false });
                        //objMonitorConnections.push({ start: monitorStartIndexes[1] + monitorOpenXmlTagString.length, stop: monitorStopIndexes[1], stringPart: body.substring(monitorStartIndexes[1] + monitorOpenXmlTagString.length, monitorStopIndexes[1]), connectionStatus: "", match: false });
                        
                        for (var b = 0; b < objMonitorConnections.length; b++) {

                            var stateOpenXmlTagString = "<STATE>";
                            var stateCloseXmlTagString = "</STATE>";

                            var tagStateStart = objMonitorConnections[b].stringPart.indexOf(stateOpenXmlTagString); // "<STATE>"
                            var tagStateStop = objMonitorConnections[b].stringPart.indexOf(stateCloseXmlTagString); // "</STATE>"

                            //logger.debug("%s tagStateStart: %d".sprintf(logHeader, tagStateStart));
                            //logger.debug("%s tagStateStop: %d".sprintf(logHeader, tagStateStop));

                            objMonitorConnections[b].connectionStatus = objMonitorConnections[b].stringPart.substring(tagStateStart + stateOpenXmlTagString.length, tagStateStop);
                            logger.debug("%s objMonitorConnections[%d].connectionStatus: %s".sprintf(logHeader, b, objMonitorConnections[b].connectionStatus));
                        }

                        //logger.debug("%s monitorConnectionsStatus: %s".sprintf(logHeader, monitorConnectionsStatus));

                        //logger.debug("%s objMonitorConnections loop start".sprintf(logHeader));
                        for (var b = 0; b < objMonitorConnections.length; b++) {

                            //logger.debug("%s objMonitorConnections[%d].connectionStatus: %s".sprintf(logHeader, b, objMonitorConnections[b].connectionStatus));
                            if (objMonitorConnections[b].connectionStatus == "CONNECTED") {

                                monitorConnectionsStatus = monitorConnectionsStatus && true;

                            } else {

                                monitorConnectionsStatus = monitorConnectionsStatus && false;
                            }
                            //logger.debug("%s monitorConnectionsStatus: %s".sprintf(logHeader, monitorConnectionsStatus));
                        }
                        //logger.debug("%s objMonitorConnections loop stop".sprintf(logHeader));

                        if (monitorConnectionsStatus == false) {

                            logger.warning("%s monitor connections DISCONNECTED".sprintf(logHeader));

                        } else {

                            logger.info("%s monitor connections CONNECTED".sprintf(logHeader));
                        }

                    } else {

                        // mh201 monitor ports all disconnected
                        monitorConnectionsStatus = false;
                        logger.warning("%s monitor connections DISCONNECTED".sprintf(logHeader));
                    }

                    logger.debug("%s monitorConnectionsStatus: %s".sprintf(logHeader, monitorConnectionsStatus ? "true" : "false"));

                    ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].push(monitorConnectionsStatus);
                    logger.debug("%s monitorStatusHistory push %s".sprintf(logHeader, monitorConnectionsStatus ? "true" : "false"));

                    // +OFD
                    //ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].push(ownGatewaysWatchDogs[id].connectionStatusesTestSequence[MONITOR][this.counter]);
                    //logger.info("%s monitorStatusHistory push %s".sprintf(prefix, ownGatewaysWatchDogs[id].connectionStatusesTestSequence[MONITOR][this.counter] ? "true" : "false"));
                    // -OFD

                    // COMMANDS CONNECTION STATUS

                    var commandStartIndexes = indexes(body, commandOpenXmlTagString);   // "<OPEN_COMMAND_SOCKET>"
                    var commandStopIndexes = indexes(body, commandCloseXmlTagString);    // "</OPEN_COMMAND_SOCKET>"

                    //logger.debug("%s commandStartIndexes: %s".sprintf(logHeader, commandStartIndexes));
                    //logger.debug("%s commandStopIndexes: %s".sprintf(logHeader, commandStopIndexes));

                    //if (commandStartIndexes.length == 2 && commandStopIndexes.length == 2) {
                    if (commandStartIndexes.length == connections && commandStopIndexes.length == connections) {

                        //logger.debug("%s commandStartIndexes.length: %d equal to commandStopIndexes.length: %d".sprintf(logHeader, commandStartIndexes.length, commandStopIndexes.length));

                        var objCommandConnections = [];
                        for (var t = 0; t < connections; t++) {

                            objCommandConnections.push({ start: commandStartIndexes[t] + monitorOpenXmlTagString.length, stop: commandStopIndexes[t], stringPart: body.substring(commandStartIndexes[t] + monitorOpenXmlTagString.length, commandStopIndexes[t]), connectionStatus: "" });
                        }

                        //objCommandConnections.push({ start: commandStartIndexes[0] + monitorOpenXmlTagString.length, stop: commandStopIndexes[0], stringPart: body.substring(commandStartIndexes[0] + monitorOpenXmlTagString.length, commandStopIndexes[0]), connectionStatus: "", match: false });
                        //objCommandConnections.push({ start: commandStartIndexes[1] + monitorOpenXmlTagString.length, stop: commandStopIndexes[1], stringPart: body.substring(commandStartIndexes[1] + monitorOpenXmlTagString.length, commandStopIndexes[1]), connectionStatus: "", match: false });

                        for (var b = 0; b < objCommandConnections.length; b++) {

                            var stateOpenXmlTagString = "<STATE>";
                            var stateCloseXmlTagString = "</STATE>";

                            var tagStateStart = objCommandConnections[b].stringPart.indexOf(stateOpenXmlTagString); // "<STATE>"
                            var tagStateStop = objCommandConnections[b].stringPart.indexOf(stateCloseXmlTagString); // "</STATE>"

                            //logger.debug("%s tagStateStart: %d".sprintf(logHeader, tagStateStart));
                            //logger.debug("%s tagStateStop: %d".sprintf(logHeader, tagStateStop));

                            objCommandConnections[b].connectionStatus = objCommandConnections[b].stringPart.substring(tagStateStart + stateOpenXmlTagString.length, tagStateStop);
                            logger.debug("%s objCommandConnections[%d].connectionStatus: %s".sprintf(logHeader, b, objCommandConnections[b].connectionStatus));
                        }

                        //logger.debug("%s commandConnectionsStatus: %s".sprintf(logHeader, commandConnectionsStatus));

                        //logger.debug("%s objCommandConnections loop start".sprintf(logHeader));
                        for (var b = 0; b < objCommandConnections.length; b++) {

                            //logger.debug("%s objCommandConnections[%d].connectionStatus: %s".sprintf(logHeader, b, objCommandConnections[b].connectionStatus));
                            if (objCommandConnections[b].connectionStatus == "CONNECTED") {

                                commandConnectionsStatus = commandConnectionsStatus && true;

                            } else {

                                commandConnectionsStatus = commandConnectionsStatus && false;
                            }
                            //logger.debug("%s commandConnectionsStatus: %s".sprintf(logHeader, commandConnectionsStatus));
                        }
                        //logger.debug("%s objCommandConnections loop stop".sprintf(logHeader));

                        if (commandConnectionsStatus == false) {

                            logger.warning("%s command connections DISCONNECTED".sprintf(logHeader));

                        } else {

                            logger.info("%s command connections CONNECTED".sprintf(logHeader));
                        }

                    } else {

                        // mh201 monitor ports all disconnected
                        commandConnectionsStatus = false;
                        logger.warning("%s command connections DISCONNECTED".sprintf(logHeader));
                    }

                    logger.debug("%s commandConnectionsStatus: %s".sprintf(logHeader, commandConnectionsStatus ? "true" : "false"));

                    ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].push(commandConnectionsStatus);
                    logger.debug("%s commandsStatusHistory push %s".sprintf(logHeader, commandConnectionsStatus ? "true" : "false"));

                    // +OFD
                    //ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].push(ownGatewaysWatchDogs[id].connectionStatusesTestSequence[COMMANDS][this.counter]);
                    //logger.info("%s commandsStatusHistory push %s".sprintf(prefix, ownGatewaysWatchDogs[id].connectionStatusesTestSequence[COMMANDS][this.counter] ? "true" : "false"));

                    //this.counter++;
                    //logger.info("%s counter: %d, turn at iteration: %d".sprintf(logHeader, this.counter, ownGatewaysWatchDogs[id].connectionStatusesTestSequence[MONITOR].length - 1));
                    //if (this.counter > ownGatewaysWatchDogs[id].connectionStatusesTestSequence[MONITOR].length - 1) {
                    //   this.counter = 0;
                    //   logger.info("%s counter reset: 0".sprintf(logHeader));
                    //}
                    // -OFD

                } else {

                    var body = response.body;

                    if (isNaN(response.code)) {

                        logger.warning("%s http response code different from 200: %s".sprintf(logHeader, response.code));
                        logger.warning("%s response body: %s".sprintf(logHeader, response.body));

                    } else {

                        logger.warning("%s http response code different from 200: %d".sprintf(logHeader, response.code));
                        logger.warning("%s response body: %s".sprintf(logHeader, response.body));
                    }

                    // COMMANDS
                    commandConnectionsStatus = false;
                    logger.warning("%s command connections DISCONNECTED".sprintf(logHeader));

                    ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].push(commandConnectionsStatus);
                    logger.debug("%s commandsStatusHistory push %s".sprintf(logHeader, commandConnectionsStatus ? "true" : "false"));

                    // MONITOR
                    monitorConnectionsStatus = false;
                    logger.warning("%s monitor connections DISCONNECTED".sprintf(logHeader));

                    ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].push(monitorConnectionsStatus);
                    logger.debug("%s monitorStatusHistory push %s".sprintf(logHeader, monitorConnectionsStatus ? "true" : "false"));
                }

                // COMMANDS CONNECTION
                for (var k = 0; k < ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].length; k++) {

                    logger.debug("%s commandsStatusHistory[%d]: %s".sprintf(logHeader, k, ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].list(k)));
                }

                // analyze queue items only if queue contains at least BUFFER items.
                if (ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].length > parseInt((BUFFER - 1), 10)) {

                    analyzeConnectionStatusesSequence(id, COMMANDS);
                }

                logger.debug("%s ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].length: %d greater than: %d ? %s".sprintf(logHeader, id, COMMANDS, ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].length, parseInt((BUFFER - 1), 10), (ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].length > parseInt((BUFFER - 1), 10)) ? "TRUE" : "FALSE"));
                if (ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].length > parseInt((BUFFER - 1), 10)) {

                    ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].shift();
                    logger.debug("%s shift ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].length: %d".sprintf(logHeader, id, COMMANDS, ownGatewaysWatchDogs[id].connectionStatusHistory[COMMANDS].length));
                }

                // MONITOR CONNECTION
                for (var k = 0; k < ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].length; k++) {

                    logger.debug("%s monitorStatusHistory[%d]: %s".sprintf(logHeader, k, ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].list(k)));
                }

                // analyze queue items only if queue contains at least BUFFER items.
                if (ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].length > parseInt((BUFFER - 1), 10)) {

                    analyzeConnectionStatusesSequence(id, MONITOR);
                }

                logger.debug("%s ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].length: %d greater than: %d ? %s".sprintf(logHeader, id, MONITOR, ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].length, parseInt((BUFFER - 1), 10), (ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].length > parseInt((BUFFER - 1), 10)) ? "TRUE" : "FALSE"));
                if (ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].length > parseInt((BUFFER - 1), 10)) {

                    ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].shift();
                    logger.debug("%s shift ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].length: %d".sprintf(logHeader, id, MONITOR, ownGatewaysWatchDogs[id].connectionStatusHistory[MONITOR].length));
                }

            } catch (ex) {

                logger.error("%s exception: %s".sprintf(logHeader, ex));
            }
        }

        function analyzeConnectionStatusesSequence(id, connectionType) {

            var logHeader = "%s analyzeConnectionStatusesSequence %s id: %d".sprintf(prefix, (connectionType == 0) ? "MONITOR" : "COMMANDS", id );

            logger.debug("%s analyze: %d, debugXml: %d, ignored: %d".sprintf(logHeader, ownGatewaysWatchDogs[id].analyze[connectionType], ownGatewaysWatchDogs[id].debugXml[connectionType], ownGatewaysWatchDogs[id].ignored[connectionType]));

            if (ownGatewaysWatchDogs[id].analyze[connectionType] == false) {

                // nothing to do but increase ignored value
                ownGatewaysWatchDogs[id].ignored[connectionType]++;

                if (ownGatewaysWatchDogs[id].ignored[connectionType] == IGNORE) {

                    logger.debug("%s ignored reached IGNORE value: %d, restarting normal analysis".sprintf(logHeader, IGNORE));

                    var oldAnalyzeValue = ownGatewaysWatchDogs[id].analyze[connectionType];
                    var oldIgnoredValue = ownGatewaysWatchDogs[id].ignored[connectionType];

                    ownGatewaysWatchDogs[id].analyze[connectionType] = true;
                    ownGatewaysWatchDogs[id].ignored[connectionType] = 0;

                    logger.debug("%s analyze: %d -> %d, ignored: %d -> %d".sprintf(logHeader, oldAnalyzeValue, ownGatewaysWatchDogs[id].analyze[connectionType], oldIgnoredValue, ownGatewaysWatchDogs[id].ignored[connectionType]));

                } else {

                    logger.debug("%s ignored value: %d less than IGNORE value: %d, analysis suspended".sprintf(logHeader, ownGatewaysWatchDogs[id].ignored[connectionType], IGNORE));
                }

            } else {

                var sum = 0;
                //logger.info("%s analyzeConnectionStatusesSequence: ownGatewaysWatchDogs[%d].monitorStatusHistory[%d]: %s".sprintf(prefix, id, BUFFER - 1, ownGatewaysWatchDogs[id].monitorStatusHistory.list(BUFFER - 1)));
                var helperConnectionStatus = ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(BUFFER - 1);    // queue last value
                logger.debug("%s helperConnectionStatus: %s".sprintf(logHeader, helperConnectionStatus));

                if (helperConnectionStatus == false) {

                    for (var i = ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].length - 2; i > ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].length - 1 - ALARM; i--) {

                        logger.debug("%s i: %d, ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].list(%d): %s".sprintf(logHeader, i, id, connectionType, i, ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i)));

                        if (ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i) == helperConnectionStatus) {

                            sum++;
                            logger.debug("%s ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].list(%d): %s == helperConnectionStatus: %s so increase sum value to: %d".sprintf(logHeader, id, connectionType, i, ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i), helperConnectionStatus, sum));

                        } else {

                            logger.debug("%s ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].list(%d): %s != helperConnectionStatus: %s so exit loop".sprintf(logHeader, id, connectionType, i, ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i), helperConnectionStatus));
                            break;
                        }
                    }

                    if (sum == (ALARM - 1)) {

                        logger.warning("%s PORT DISCONNECTION DETECTED".sprintf(logHeader));

                        // means items from index (BUFFER - 1)  to index (BUFFER - 1 - ALARM) have all the same FALSE value
                        // there is a disconnection and watch dog have to execute a debug.xml on the own server or a driver reboot if REBOOT
                        // debug.xml have been executed on the own server
                        if (ownGatewaysWatchDogs[id].debugXml[connectionType] < REBOOT) {

                            //send debug.xml to own server
                            logger.info("%s debugXml: %d less than REBOOT: %d, so SEND DEBUG.XML to own server".sprintf(logHeader, ownGatewaysWatchDogs[id].debugXml[connectionType], REBOOT));

                            var oldDebugXmlValue = ownGatewaysWatchDogs[id].debugXml[connectionType];
                            var oldAnalyzeValue = ownGatewaysWatchDogs[id].analyze[connectionType];
                            var oldIgnoredValue = ownGatewaysWatchDogs[id].ignored[connectionType];

                            ownGatewaysWatchDogs[id].debugXml[connectionType]++;
                            ownGatewaysWatchDogs[id].analyze[connectionType] = false;    // stop analyzing next < IGNORE > connection statuses value
                            ownGatewaysWatchDogs[id].ignored[connectionType] = 0;        // reset ignored

                            logger.debug("%s debugXml: %d -> %d, analyze: %d -> %d, ignored: %d -> %d".sprintf(logHeader, oldDebugXmlValue, ownGatewaysWatchDogs[id].debugXml[connectionType], oldAnalyzeValue, ownGatewaysWatchDogs[id].analyze[connectionType], oldIgnoredValue, ownGatewaysWatchDogs[id].ignored[connectionType]));

                            var httpMessage = "http://%s/debug.xml".sprintf(ownGatewaysWatchDogs[id].ipAddress);
                            logger.info("%s sending http message: %s".sprintf(logHeader, httpMessage));
                            
                            //var response = this.httpclient.getURL(httpMessage);
                            var response = ownGatewaysWatchDogs[id].httpclient.getURL(httpMessage);

                        } else {

                            // driver reboot
                            logger.info("%s debugXml: %d equal to REBOOT: %d, so RESTART THE DRIVER".sprintf(logHeader, ownGatewaysWatchDogs[id].debugXml[connectionType], REBOOT));

                            rebootTimer.start();
                        }

                    } else {

                        logger.debug("%s last connection statuses have not the same value: %s".sprintf(logHeader, helperConnectionStatus));
                    }

                } else {

                    logger.debug("%s last connection status: true, connection is ok!".sprintf(logHeader));

                    // analyse last 3 connection statuses sequence
                    for (var i = ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].length - 2; i > ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].length - 1 - ALARM; i--) {

                        logger.debug("%s i: %d, ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].list(%d): %s".sprintf(logHeader, i, id, connectionType, i, ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i)));

                        if (ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i) == helperConnectionStatus) {

                            sum++;
                            logger.debug("%s ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].list(%d): %s == helperConnectionStatus: %s so increase sum value to: %d".sprintf(logHeader, id, connectionType, i, ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i), helperConnectionStatus, sum));

                        } else {

                            logger.debug("%s ownGatewaysWatchDogs[%d].connectionStatusHistory[%d].list(%d): %s != helperConnectionStatus: %s so break for loop".sprintf(logHeader, id, connectionType, i, ownGatewaysWatchDogs[id].connectionStatusHistory[connectionType].list(i), helperConnectionStatus));
                            break;
                        }
                    }

                    if (sum == (ALARM - 1)) {

                        logger.info("%s PORT CONNECTION IS OK!".sprintf(logHeader));

                        // means items from index (BUFFER - 1)  to index (BUFFER - 1 - ALARM) have all the same TRUE value
                        // connection is fine and watch dog has to clean variables value

                        var oldDebugXmlValue = ownGatewaysWatchDogs[id].debugXml[connectionType];
                        var oldAnalyzeValue = ownGatewaysWatchDogs[id].analyze[connectionType];
                        var oldIgnoredValue = ownGatewaysWatchDogs[id].ignored[connectionType];

                        ownGatewaysWatchDogs[id].debugXml[connectionType] = 0;      // now everything is fine so next time connection is failure watch dog will send a debug.xml first
                        ownGatewaysWatchDogs[id].analyze[connectionType] = true;    // stop analyzing next < IGNORE > connection statuses value
                        ownGatewaysWatchDogs[id].ignored[connectionType] = 0;       // reset ignored

                        logger.debug("%s debugXml: %d -> %d, analyze: %d -> %d, ignored: %d -> %d".sprintf(logHeader, oldDebugXmlValue, ownGatewaysWatchDogs[id].debugXml[connectionType], oldAnalyzeValue, ownGatewaysWatchDogs[id].analyze[connectionType], oldIgnoredValue, ownGatewaysWatchDogs[id].ignored[connectionType]));
                    }
                }
            }

            logger.debug("%s analyze: %d, debugXml: %d, ignored: %d".sprintf(logHeader, ownGatewaysWatchDogs[id].analyze[connectionType], ownGatewaysWatchDogs[id].debugXml[connectionType], ownGatewaysWatchDogs[id].ignored[connectionType]));
        }

        var Queue = function () {

            var functionSet = (function () {

                var _elements = []; // creating a private array
                return [
                // push function
                function ()
                { return _elements.push.apply(_elements, arguments); },
                // shift function
                function ()
                { return _elements.shift.apply(_elements, arguments); },
                function () { return _elements.length; },
                function (n) { return _elements.length = n; },
                function (t) { return _elements[t]; }];
            })();
            this.push = functionSet[0];
            this.shift = functionSet[1];
            this.list = functionSet[4],
            Object.defineProperty(this, 'length', {

                'get': functionSet[2],
                'set': functionSet[3],
                'writeable': true,
                'enumerable': false,
                'configurable': false
            });
            // initializing the queue with given arguments
            this.push.apply(this, arguments);
        }

        if (TIMEOUT > 0) {

            logger.info("%s adding watchDogTimeoutCallback callback".sprintf(prefix));
            timerIndex = timerManager.add(new TimerObject(60, "watchDogTimeoutCallback", watchDogTimeoutCallback, false, 9999));
            timerManager.start(timerIndex);
        }
    }

    return drv;
})();